if (document.getElementById("studentlogin")) {
  document.getElementById("studentlogin").addEventListener("click", studentlogin);
}

if (document.getElementById("stafflogin")) {
  document.getElementById("stafflogin").addEventListener("click", stafflogin);
}
if (document.getElementById("updateProfileBtn")) {
  document.getElementById("updateProfileBtn").addEventListener("click", getStarted);
}

function studentlogin() {
  const username = document.getElementById("username").value
  const password = document.getElementById("password").value
  const account_type = document.getElementById("account_type").value

  jQuery.ajax({
    url: `/user/login`,
    method: 'POST',
    data: {
      username,
      password,
      account_type
    },
    error: function (request, error) {
      console.log(error)
      toastr.options.progressBar = true;
      toastr.error(
        error,
        "ERROR", {
          timeOut: 9000
        }
      );
      
    },
    success: function (data) {
      if (data.success === false) {
        toastr.options.progressBar = true;
        toastr.error(
          data.error,
          "ERROR", {
            timeOut: 9000
          }
        );
      }
      if (data.success === true) {
        toastr.options.progressBar = true;
        toastr.success(
          data.message,
          "SUCCESS", {
            timeOut: 9000
          }
        );
        localStorage.setItem('token', data.token);
        window.location.href = "/student-dashboard"
      }

    }
  });
}

function stafflogin() {
  const username = document.getElementById("username").value
  const password = document.getElementById("password").value

  jQuery.ajax({
    url: `/user/login`,
    method: 'POST',
    data: {
      username,
      password
    },
    error: function (request, error) {
      toastr.options.progressBar = true;
      toastr.error(
        error,
        "ERROR", {
          timeOut: 9000
        }
      );
    },
    success: function (data) {
      if (data.success === false) {
        toastr.options.progressBar = true;
        toastr.error(
          data.error,
          "ERROR", {
            timeOut: 9000
          }
        );
      }
      // alert(data.user.role )
      if(data.user.role == "1"){
        toastr.options.progressBar = true;
        toastr.success(
          data.message,
          "SUCCESS", {
            timeOut: 9000
          }
        );
        window.location.href = "/admin/"
        return
      }
      if (data.success === true) {
        toastr.options.progressBar = true;
        toastr.success(
          data.message,
          "SUCCESS", {
            timeOut: 9000
          }
        );
        window.location.href = "/staff-dashboard"
      }

    }
  });
}

function getStarted() {
  const email = document.getElementById("email").value
  const phone = document.getElementById("phone").value
  const username = document.getElementById("username").value
 if(!email || !phone){
   toastr.options.progressBar = true;
          toastr.error(
            "All field are required",
            "ERROR", {
              timeOut: 9000
            }
          );
          return
 }
  jQuery.ajax({
    url: `/user/get-started`,
    method: 'POST',
    data: {
      email,
      phone,
      username
    },
    error: function (request, error) {
      toastr.options.progressBar = true;
      toastr.error(
        error,
        "ERROR", {
          timeOut: 9000
        }
      );
    },
    success: function (data) {
      if (data.success === false) {
        toastr.options.progressBar = true;
        toastr.error(
          data.error,
          "ERROR", {
            timeOut: 9000
          }
        );
      }

      if (data.success === true) {
        toastr.options.progressBar = true;
        toastr.success(
          data.message,
          "SUCCESS", {
            timeOut: 200000
          }
        );
        alert("Record succesfully updated!")
        window.location.href = "/student-dashboard"
      }

    }
  });
}