const User = require("../../../models").users;
const Profile = require("../../../models").profiles;
const Roles = require("../../../models").roles;
const Department = require("../../../models").departments;
const Session = require("../../../models").sessions;
const CryptoJS = require("crypto-js");
var key = CryptoJS.enc.Base64.parse("4gt71TxD1e4P3433");
var iv = CryptoJS.enc.Base64.parse("4gt71TxD1e4P3433");
const { randomString } = require("../../helpers/randomString");

exports.adminUser = async (req, res) => {
  try {
    const { deleted } = req.query;
    const adminUser = await User.findAll({
      where: {
        second_role: 1,
      },
      include: [{ model: Roles, as: "roles" }],
    });

    const roles = await Roles.findAll({ where: { active: true } });
    const sessions = await Session.findAll({ raw: true });
    return res.render("admin/adminusers.ejs", {
      users: adminUser,
      roles,
      deleted,
      user: req.user,
      sessions,
    });
  } catch (error) {
    console.log(error);
    return res.status(500).send({ success: false, message: error.message });
  }
};
exports.getAdmin = async (req, res) => {
  try {
    const { id } = req.params;
    const supervisor = await Profile.findOne({
      where: { user_id: id },
      attributes: [
        "id",
        "user_id",
        "department_id",
        "firstname",
        "lastname",
        "middlename",
        "createdAt",
      ],
      include: [
        {
          model: User,
          attributes: ["username"],
        },
        {
          model: Department,
        },
        {
          model: Roles,
          as: "firstRole",
        },
        {
          model: Roles,
          as: "secondRole",
        },
      ],
    });

    const sessions = await GetSession.findAll({ raw: true });
    return res.status(200).send({
      success: true,
      supervisor,
      user: req.user,
      sessions,
      message: "Record successfully fetched!",
    });
  } catch (error) {
    return res.status(500).send({ success: false, message: error.message });
  }
};
exports.createUser = async (req, res) => {
  try {
    const { username, firstname, lastname, role, middlename, password, title } =
      req.body;

    const checkUser = await User.findOne({ where: { username } });
    if (checkUser)
      return res.status(200).send({
        success: false,
        message: "User with the username already exist",
      });

    const userPassword = CryptoJS.AES.encrypt(password, key, {
      iv: iv,
    }).toString();

    let roleDetails = await Roles.findOne({ where: { alias: role } });
    roleDetails = JSON.parse(JSON.stringify(roleDetails));
    const user = await User.create({
      username,
      password: userPassword,
      slug: randomString(20),
      role: 1,
      second_role: roleDetails?.id,
      active: true,
      firstname,
      lastname,
      middlename,
    });
    return res
      .status(200)
      .send({ success: true, message: "User successfully created!", ...user });
  } catch (error) {
    console.log(error);
    return res.status(500).send({ success: false, message: error.message });
  }
};
exports.deleteAdmin = async (req, res) => {
  try {
    const { id } = req.params;
    await User.destroy({ where: { id } });
    await Profile.destroy({ where: { user_id: id } });

    return res.redirect("/admin/admin-user?deleted=true");
  } catch (error) {
    console.log(error);
    return res.status(500).send({ success: false, message: error.message });
  }
};
