const { where } = require("sequelize");
const Sequelize = require("sequelize");
const User = require("../../../models").users;
const Profile = require("../../../models").profiles;
const ProjectType = require("../../../models").project_types;
const { Op } = require("sequelize");
const Department = require("../../../models").departments;
const Group = require("../../../models").groups;
const Institute = require("../../../models").institutes;
const Packages = require("../../../models").packages;
const Subcriptions = require("../../../models").subscriptions;
const PaystackDetails = require("../../../models").paystack_details;
const paymentHistory = require("../../../models").payment_history;
const BindingPayment = require("../../../models").binding_payments;
const appendDateFilter = require("../../helpers/appendDateFilter");
const env = process.env.NODE_ENV || "development";
const Session = require("../../../models").sessions;
const readXlsxFile = require("read-excel-file/node");
const fs = require("fs");
// const config = require( '../../../config/config.json')[env];
// const sequelize = new Sequelize(config.database, config.username, config.password, config);

const sequelize = require("../../../config/connection");
const TEST_SECRET_KEY = "";
const LIVE_SECRET_KEY = "";
async function getsession() {
  const ses = await Session.findAll({ raw: true });
  return ses;
}
const sessions = getsession();
exports.paymentReport = async (req, res) => {
  try {
    const {
      startDate,
      endDate,
      institute,
      department_id,
      projectTypeId,
      status,
    } = req.query;
    let query = {};
    let results;
    let getPayemtHistory;
    let transactionSum;
    let transactionCount;
    if (projectTypeId) query.package_id = projectTypeId;
    if (status) query.txn_status = status;

    let queryDate = {};
    if (startDate && endDate) {
      queryDate = {
        ...appendDateFilter(startDate, endDate, sequelize, "payment_history"),
      };
    }

    const departments = await Department.findAll({});
    const institutes = await Institute.findAll({});
    const projectType = await ProjectType.findAll({});
    transactionCount = await paymentHistory.count({
      where: { txn_status: "success", ...query, ...queryDate },
    });
    transactionSum = await paymentHistory.findAll({
      where: { txn_status: "success", ...query, ...queryDate },
      attributes: [
        [Sequelize.fn("sum", Sequelize.col("amount")), "totalAmount"],
      ],
    });
    transactionSum = JSON.parse(JSON.stringify(transactionSum));

    getPayemtHistory = await paymentHistory.findAll({
      where: { ...query, ...queryDate },
      include: [
        { model: Packages },
        {
          model: Profile,
          include: [
            {
              model: Department,
              include: [
                {
                  model: Institute,
                },
              ],
            },
          ],
        },
      ],
      order: [["createdAt", "DESC"]],
      limit: 2000,
    });
    transactionSum = transactionSum[0].totalAmount;
    if (institute) {
      [transactionCount, metadata] =
        await sequelize.query(`SELECT count(*) FROM payment_history 
            INNER JOIN users  ON payment_history.username = users.username 
            INNER JOIN profiles ON users.id = profiles.user_id 
            INNER JOIN departments ON profiles.department_id = departments.id
            INNER JOIN institutes ON departments.institute_id = institutes.id WHERE institute_id = ${institute} AND txn_status = "success"`);

      [transactionSum, metadata] =
        await sequelize.query(`SELECT sum(amount) FROM payment_history 
            INNER JOIN users  ON payment_history.username = users.username 
            INNER JOIN profiles ON users.id = profiles.user_id 
            INNER JOIN departments ON profiles.department_id = departments.id
            INNER JOIN institutes ON departments.institute_id = institutes.id WHERE institute_id = ${institute} AND txn_status = "success"`);

      [results, metadata] =
        await sequelize.query(`SELECT * FROM payment_history 
            INNER JOIN users  ON payment_history.username = users.username 
            INNER JOIN profiles ON users.id = profiles.user_id 
            INNER JOIN departments ON profiles.department_id = departments.id
            INNER JOIN institutes ON departments.institute_id = institutes.id WHERE institute_id = ${institute} `);
      getPayemtHistory = results;
      transactionCount = transactionCount[0]["count(*)"];
      transactionSum = transactionSum[0]["sum(amount)"];
    }

    if (department_id) {
      [transactionCount, metadata] =
        await sequelize.query(`SELECT count(*) FROM payment_history 
            INNER JOIN users  ON payment_history.username = users.username 
            INNER JOIN profiles ON users.id = profiles.user_id 
            INNER JOIN departments ON profiles.department_id = departments.id
            INNER JOIN institutes ON departments.institute_id = institutes.id WHERE department_id = ${department_id} AND txn_status = "success"`);

      [transactionSum, metadata] =
        await sequelize.query(`SELECT sum(amount) FROM payment_history 
            INNER JOIN users  ON payment_history.username = users.username 
            INNER JOIN profiles ON users.id = profiles.user_id 
            INNER JOIN departments ON profiles.department_id = departments.id
            INNER JOIN institutes ON departments.institute_id = institutes.id WHERE department_id = ${department_id} AND txn_status = "success"`);

      [results, metadata] =
        await sequelize.query(`SELECT * FROM payment_history 
            INNER JOIN users  ON payment_history.username = users.username 
            INNER JOIN profiles ON users.id = profiles.user_id 
            INNER JOIN departments ON profiles.department_id = departments.id
            INNER JOIN institutes ON departments.institute_id = institutes.id WHERE department_id = ${department_id} `);
      getPayemtHistory = results;
      transactionCount = transactionCount[0]["count(*)"];
      transactionSum = transactionSum[0]["sum(amount)"];
    }
    return res.render("admin/payments.ejs", {
      error: false,
      getPayemtHistory,
      transactionCount,
      transactionSum,
      departments,
      projectType,
      institutes,
      user: req.user,
      sessions,
    });
  } catch (error) {
    return res.render("admin/payments.ejs", {
      user: req.user,
      error: error.message,
      getPayemtHistory: [],
      transactionCount: 0,
      transactionSum: 0,
      departments: [],
      projectType: [],
      institutes: [],
    });
  }
};
exports.paymentAudit = async (req, res) => {
  try {
    const { startDate, endDate, username } = req.query;
    let query = {};
    let results;
    let getPayemtHistory;
    let transactionSum;
    let transactionCount;
    if (username) query.username = { [Op.startsWith]: username };
    let queryDate = {};
    if (startDate && endDate) {
      queryDate = {
        ...appendDateFilter(startDate, endDate, sequelize, "payment_history"),
      };
    }

    const departments = await Department.findAll({});
    const institutes = await Institute.findAll({});
    const projectType = await ProjectType.findAll({});

    getPayemtHistory = await paymentHistory.findAll({
      where: { ...query, ...queryDate, txn_status: "success", package_id: 1 },
      include: [
        { model: Packages },
        {
          model: Profile,
          include: [
            {
              model: Department,
              include: [
                {
                  model: Institute,
                },
              ],
            },
          ],
        },
      ],
      order: [["createdAt", "DESC"]],
      limit: 2000,
    });

    return res.render("admin/payment-audit.ejs", {
      error: false,
      getPayemtHistory,
      transactionCount,
      transactionSum,
      departments,
      projectType,
      institutes,
      user: req.user,
      sessions,
    });
  } catch (error) {
    console.log(error);
    return res.render("admin/payment-audit.ejs", {
      user: req.user,
      error: error.message,
      getPayemtHistory: [],
      transactionCount: 0,
      transactionSum: 0,
      departments: [],
      projectType: [],
      institutes: [],
    });
  }
};
exports.verifyPayment = async (req, res) => {
  try {
    const paystackKey = await PaystackDetails.findAll();
    const paystack = require("paystack")(paystackKey[0].LIVE_SECRET_KEY);
    // const paystack = require("paystack")(paystackKey[0].TEST_SECRET_KEY);
    const paystackReference = req.body.reference;

    if (!paystackReference) {
      return res.status(200).send({
        statusCode: "401",
        success: false,
        message: "Error",
        error: "Payment reference is required",
      });
    }

    var paystackCallbackRes;
    const verifyPay = await paystack.transaction
      .verify(paystackReference)
      .then((transaction) => {
        paystackCallbackRes = transaction.data;
      });

    if (paystackCallbackRes?.status != undefined) {
      var findSUb = await Subcriptions.findOne({
        where: {
          payment_id: paystackCallbackRes.reference,
        },
      });
      if (paystackCallbackRes.status === "success" && findSUb === null) {
        const findPaymentHistory = await paymentHistory.findOne({
          where: {
            txn_ref: paystackCallbackRes.reference,
            username: paystackCallbackRes.metadata.matricNumber,
          },
        });

        const updateUser = {
          payment_status: "PAID",
        };
        const updatePaid = await User.update(updateUser, {
          where: {
            username: paystackCallbackRes.metadata.matricNumber,
          },
        });

        var findUser = await User.findOne({
          where: {
            username: paystackCallbackRes.metadata.matricNumber,
          },
        });

        const createSub = await Subcriptions.create({
          user_id: findUser.id,
          payment_id: paystackCallbackRes.reference,
          pakage_id: findPaymentHistory.package_id,
        });

        const updatePayment = {
          txn_desc: paystackCallbackRes.gateway_response,
          txn_status: paystackCallbackRes.status,
          txn_channel: paystackCallbackRes.channel,
        };

        const updateHistory = await paymentHistory.update(updatePayment, {
          where: {
            txn_ref: paystackCallbackRes.reference,
            username: paystackCallbackRes.metadata.matricNumber,
          },
        });

        if (updateHistory && createSub && updatePaid) {
          return res.status(200).send({
            statusCode: "200",
            success: true,
            message: paystackCallbackRes.gateway_response,
          });
        }
      } else {
        const updatePayment = {
          txn_desc: paystackCallbackRes.gateway_response,
          txn_status: paystackCallbackRes.status,
          txn_channel: paystackCallbackRes.channel,
        };

        const updateHistory = await paymentHistory.update(updatePayment, {
          where: {
            txn_ref: paystackCallbackRes.reference,
            username: paystackCallbackRes.metadata.matricNumber,
          },
        });

        if (updateHistory) {
          return res.status(200).send({
            statusCode: "200",
            success: true,
            message: paystackCallbackRes.gateway_response,
          });
        }
      }
    }
  } catch (e) {
    res.status(500).send({
      statusCode: "500",
      success: false,
      message: "Error",
      error: e.message,
    });
  }
};
exports.paymentRequery = async (req, res) => {
  try {
    const sess = await sessions;
    return res.render("admin/payment_requery.ejs", {
      user: req.user,
      error: false,
      sessions: sess,
    });
  } catch (e) {
    return res.render("admin/payment_requery.ejs", {
      user: req.user,
      error: false,
    });
  }
};

exports.paymentSwap = async (req, res) => {
  try {
    var requery = req.query.requery;

    const findUser = await User.findOne({
      where: {
        username: requery,
      },
    });

    var fecthPackage = await Packages.findAll({});

    if (requery) {
      var fecthSubcription = await Subcriptions.findAll({
        where: {
          user_id: findUser.id,
        },
      });

      var eachPakages = [];

      for (const fecthSubcriptions of JSON.parse(
        JSON.stringify(fecthSubcription)
      )) {
        const GetPackages = await Packages.findOne({
          where: {
            id: fecthSubcriptions.pakage_id,
          },
        });

        eachPakages.push({
          ...fecthSubcriptions,
          package_name: GetPackages?.name,
          package: JSON.parse(JSON.stringify(fecthPackage)),
        });
      }
    }

    console.log(eachPakages);

    return res.render("admin/payment_swap.ejs", {
      user: req.user,
      error: false,
      userSwap: eachPakages,
      fecthPackage,
      sessions,
    });
  } catch (e) {
    return res.render("admin/payment_swap.ejs", {
      user: req.user,
      error: false,
      userSwap: [],
    });
  }
};

exports.SwapPayment = async (req, res) => {
  const matricNumber = req.body.matricNumber;

  if (!matricNumber) {
    return res.status(200).send({
      statusCode: "200",
      success: false,
      message: "Error",
      error: "Matric number is required",
    });
  }
  try {
    const findUser = await User.findOne({
      where: {
        username: matricNumber,
      },
    });

    var fecthSubcription = await Subcriptions.findAll({
      where: {
        user_id: findUser.id,
      },
    });

    return res.status(200).send({
      statusCode: "200",
      success: true,
      message: "Success",
      url: "/admin/paymentswap?requery=" + matricNumber,
    });
  } catch (error) {
    console.log(error);
    return res.render("admin/payment_swap.ejs", {
      user: req.user,
      error: error.message,
      userSwap: [],
    });
  }
};

exports.SwapPaymentSubcription = async (req, res) => {
  try {
    const user_id = req.body.user_id;
    const package_id = req.body.package_id;

    var fecthSubcription = await Subcriptions.findAll({
      where: {
        user_id,
      },
    });

    const updateSub = {
      pakage_id: package_id,
    };
    const updatedSub = await Subcriptions.update(updateSub, {
      where: {
        user_id,
      },
    });

    if (updatedSub) {
      return res.status(200).send({
        statusCode: "200",
        success: true,
        message: "Payment successfully swap",
      });
    } else {
      return res.status(200).send({
        statusCode: "200",
        success: false,
        message: "Error",
        error: "An error ocurred",
      });
    }
  } catch (e) {
    return res.render("admin/payment_swap.ejs", {
      user: req.user,
      error: false,
      userSwap: [],
    });
  }
};

exports.bindingPaymentReport = async (req, res) => {
  try {
    const {
      startDate,
      endDate,
      institute,
      department_id,
      projectTypeId,
      status,
    } = req.query;
    let query = {};
    let results;
    let getPayemtHistory;
    let transactionSum;
    let transactionCount;
    if (projectTypeId) query.package_id = projectTypeId;
    if (status) query.txn_status = status;

    let queryDate = {};
    if (startDate && endDate) {
      queryDate = {
        ...appendDateFilter(startDate, endDate, sequelize, "binding_payments"),
      };
    }

    const departments = await Department.findAll({});
    const institutes = await Institute.findAll({});
    const projectType = await ProjectType.findAll({});
    transactionCount = await BindingPayment.count({
      where: { txn_status: "success", ...query, ...queryDate },
    });
    transactionSum = await BindingPayment.findAll({
      where: { txn_status: "success", ...query, ...queryDate },
      attributes: [
        [Sequelize.fn("sum", Sequelize.col("amount")), "totalAmount"],
      ],
    });
    transactionSum = JSON.parse(JSON.stringify(transactionSum));

    [getPayemtHistory, metadata] =
      await sequelize.query(`SELECT * FROM binding_payments 
                INNER JOIN users  ON binding_payments.user_id = users.id 
                INNER JOIN departments ON users.department_id = departments.id
                INNER JOIN institutes ON departments.institute_id = institutes.id LIMIT 500`);
    transactionSum = transactionSum[0].totalAmount;
    if (institute) {
      [transactionCount, metadata] =
        await sequelize.query(`SELECT count(*) FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE institute_id = ${institute} AND txn_status = "success"`);

      [transactionSum, metadata] =
        await sequelize.query(`SELECT sum(amount) FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE institute_id = ${institute} AND txn_status = "success"`);

      [results, metadata] =
        await sequelize.query(`SELECT * FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE institute_id = ${institute} `);
      getPayemtHistory = results;
      transactionCount = transactionCount[0]["count(*)"];
      transactionSum = transactionSum[0]["sum(amount)"];
    }

    if (department_id) {
      [transactionCount, metadata] =
        await sequelize.query(`SELECT count(*) FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE department_id = ${department_id} AND txn_status = "success"`);

      [transactionSum, metadata] =
        await sequelize.query(`SELECT sum(amount) FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE department_id = ${department_id} AND txn_status = "success"`);

      [results, metadata] =
        await sequelize.query(`SELECT * FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE department_id = ${department_id} `);
      getPayemtHistory = results;
      transactionCount = transactionCount[0]["count(*)"];
      transactionSum = transactionSum[0]["sum(amount)"];
    }
    return res.render("admin/binding-payment.ejs", {
      error: false,
      getPayemtHistory,
      transactionCount,
      transactionSum,
      departments,
      projectType,
      institutes,
      user: req.user,
      sessions,
    });
  } catch (error) {
    return res.render("admin/binding-payment.ejs", {
      user: req.user,
      error: error.message,
      getPayemtHistory: [],
      transactionCount: 0,
      transactionSum: 0,
      departments: [],
      projectType: [],
      institutes: [],
    });
  }
};
exports.bindingRecord = async (req, res) => {
  try {
     const session_id = await req.params.session_id
    const { searchTearm, institute, department_id } = req.query;
    let getPayemtHistory;
    let query = {};
    let sqlQuery = "";
    if (searchTearm != undefined || searchTearm != null) {
      query.username = searchTearm;
      sqlQuery = `AND username = "${searchTearm}" `;
    }
    [getPayemtHistory, metadata] =
      await sequelize.query(`SELECT username, users.id As id, binding_payments.createdAt As createdAt,status,lastname, firstname FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE txn_status = "success" ${sqlQuery}  AND binding_payments.session_id = "${session_id}" LIMIT 500`);
    const departments = await Department.findAll({});
    const institutes = await Institute.findAll({});
    if (institute) {
      [transactionCount, metadata] =
        await sequelize.query(`SELECT count(*) FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE institute_id = ${institute} AND txn_status = "success" AND binding_payments.session_id = "${session_id}"`);

      [transactionSum, metadata] =
        await sequelize.query(`SELECT sum(amount) FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE institute_id = ${institute} AND txn_status = "success"  AND binding_payments.session_id = "${session_id}"`);

      [results, metadata] =
        await sequelize.query(`SELECT username, users.id As id, binding_payments.createdAt As createdAt,status,lastname, firstname FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE institute_id = ${institute} AND txn_status = "success" ${sqlQuery} AND binding_payments.session_id = "${session_id}"`);
      getPayemtHistory = results;
      transactionCount = transactionCount[0]["count(*)"];
      transactionSum = transactionSum[0]["sum(amount)"];
    }

    if (department_id) {
      [transactionCount, metadata] =
        await sequelize.query(`SELECT count(*) FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE department_id = ${department_id} AND txn_status = "success"  AND binding_payments.session_id = "${session_id}"`);

      [transactionSum, metadata] =
        await sequelize.query(`SELECT sum(amount) FROM binding_payments 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE department_id = ${department_id} AND txn_status = "success"  AND binding_payments.session_id = "${session_id}"`);

      [results, metadata] =
        await sequelize.query(`SELECT username, users.id As id, binding_payments.createdAt As createdAt,status,lastname, firstname FROM binding_payments 
                    INNER JOIN users  ON binding_payments.user_id = users.id 
                    INNER JOIN departments ON users.department_id = departments.id
                    INNER JOIN institutes ON departments.institute_id = institutes.id WHERE department_id = ${department_id}  AND binding_payments.session_id = "${session_id}"`);
      getPayemtHistory = results;
      transactionCount = transactionCount[0]["count(*)"];
      transactionSum = transactionSum[0]["sum(amount)"];
    }
    const totalPaid = await BindingPayment.count({ where: { status: "PAID" } });
    const totalSubmitted = await BindingPayment.count({
      where: { status: "SUBMITTED" },
    });
    const totalReady = await BindingPayment.count({
      where: { status: "READY" },
    });
    const sess = await sessions;
    return res.render("admin/binding-record.ejs", {
      error: false,
      getPayemtHistory,
      user: req.user,
      totalPaid,
      totalSubmitted,
      totalReady,
      departments,
      institutes,
      sessions: sess,
      session_id
    });
  } catch (error) {
    console.log(error);
    return res.render("admin/binding-record.ejs", {
      user: req.user,
      error: error.message,
      getPayemtHistory: [],
      totalPai: 0,
      totalSubmitted: 0,
      totalReady: 0,
      departments: [],
      institutes: [],
    });
  }
};
exports.upateBindingStatus = async (req, res) => {
  try {
    const { user_id, status } = req.body;
    await BindingPayment.update({ status }, { where: { user_id } });
    return res.status(200).send({ success: true, message: "Status Updated!" });
  } catch (error) {
    return res.status(500).send({ success: false, message: error.message });
  }
};

exports.verifyPaymentBinding = async (req, res) => {
  try {
    const paystackKey = await PaystackDetails.findAll();
    const paystack = require("paystack")(LIVE_SECRET_KEY);

    const paystackReference = req.body.reference;
    let paystackCallbackRes; // Use let instead of var for better scoping
    const verifyPay = await paystack.transaction
      .verify(paystackReference)
      .then((transaction) => {
        paystackCallbackRes = transaction.data;
      });

    if (paystackCallbackRes?.status !== undefined) {
      if (paystackCallbackRes.status === "success") {
        const updatePayment = {
          txn_desc: paystackCallbackRes.gateway_response,
          txn_status: paystackCallbackRes.status,
          txn_channel: paystackCallbackRes.channel,
        };

        // Update the payment details
        await BindingPayment.update(updatePayment, {
          where: {
            txn_ref: paystackCallbackRes.reference,
            user_id: paystackCallbackRes.metadata.user_id,
          },
        });

        // Update the user status
        const updateUser = {
          status: "PAID",
        };
        await BindingPayment.update(updateUser, {
          where: {
            txn_ref: paystackCallbackRes.reference,
            user_id: paystackCallbackRes.metadata.user_id,
          },
        });

        return res.status(200).send({
          statusCode: "200",
          success: true,
          message: paystackCallbackRes.gateway_response,
        });
      } else {
        return res.status(200).send({
          statusCode: "200",
          success: true,
          message: paystackCallbackRes.gateway_response,
        });
      }
    }
  } catch (e) {
    return res.status(500).send({
      statusCode: "500",
      success: false,
      message: "Error",
      error: e.message,
    });
  }
};
exports.bindingRecordGroup = async (req, res) => {
  let alert = "";
  let alertError = "";
  try {
    const {
      searchTearm,
      department_id,
      removestudent,
      addStudentMatric,
      leaderMatric,
    } = req.query;
    let getPayemtHistory;
    let sqlQuery = "";
    if (addStudentMatric != undefined || addStudentMatric != null) {
      const leader = await User.findOne({
        where: { username: leaderMatric },
        raw: true,
      });
      if (!leader) {
        alertError = "Invalid Matric Number for leader!";
      }
      const member = await User.findOne({
        where: { username: addStudentMatric },
        raw: true,
      });

      if (!member) {
        alertError = "Invalid Matric Number for Member!";
      }
      if (!leader?.group_id) {
        alertError = "Leader does not belong to any group!";
      }
      if (leader && member && leader.group_id) {
        await User.update(
          { has_group: true, group_id: leader.group_id },
          { where: { username: addStudentMatric } }
        );
        alert = "Student added to Group Successfully!";
      }
    }
    if (removestudent != undefined || removestudent != null) {
      await User.update(
        { has_group: false, group_id: "" },
        { where: { username: removestudent } }
      );
      alert = "Student Removed Successfully!";
    }
    if (searchTearm != undefined || searchTearm != null) {
      const user = await User.findOne({
        where: { username: searchTearm },
        raw: true,
      });
      sqlQuery = `WHERE groups.leader_id = "${user?.id}" `;
    }
    [getPayemtHistory, metadata] =
      await sequelize.query(`SELECT username, departments.name As dept,  users.id As id, groups.createdAt As createdAt,lastname, firstname FROM groups 
                        INNER JOIN users  ON groups.leader_id = users.id 
                        INNER JOIN departments ON users.department_id = departments.id ${sqlQuery} LIMIT 500`);
    const departments = await Department.findAll({});
    const institutes = await Institute.findAll({});
    if (department_id) {
      [results, metadata] =
        await sequelize.query(`SELECT username, departments.name As dept,  users.id As id, groups.createdAt As createdAt,lastname, firstname FROM groups 
                          INNER JOIN users  ON groups.leader_id = users.id 
                        INNER JOIN departments ON users.department_id = departments.id  WHERE groups.department_id= ${department_id} `);
      getPayemtHistory = results;
    }
    const totalPaid = await BindingPayment.count({ where: { status: "PAID" } });
    const totalSubmitted = await BindingPayment.count({
      where: { status: "SUBMITTED" },
    });
    const totalReady = await BindingPayment.count({
      where: { status: "READY" },
    });
    const ses = await sessions;
    return res.render("admin/binding-group.ejs", {
      error: false,
      getPayemtHistory,
      user: req.user,
      totalPaid,
      totalSubmitted,
      totalReady,
      departments,
      institutes,
      alert,
      alertError,
      sessions: ses,
    });
  } catch (error) {
    console.log(error);
    return res.render("admin/binding-group.ejs", {
      user: req.user,
      error: error.message,
      getPayemtHistory: [],
      totalPai: 0,
      totalSubmitted: 0,
      totalReady: 0,
      departments: [],
      institutes: [],
      alert,
      sessions: req.sessions,
      alertError,
    });
  }
};
exports.createGroup = async (req, res) => {
  try {
    const { groupMembers } = req.body;

    const existingUsers = await User.findAll({
      attributes: ["username", "has_group"],
      where: {
        username: groupMembers,
        has_group: false,
      },
      raw: true,
    });
    for (const groupMember of groupMembers) {
      const existingUsers = await User.findAll({
        attributes: ["username", "has_group"],
        where: {
          username: groupMember,
          has_group: false,
        },
        raw: true,
      });
      if (!existingUsers)
        return res.status(200).json({
          success: false,
          message: `${groupMember} already belong to a group or does not exist`,
        });
    }

    const leader = await User.findOne({
      where: { username: groupMembers[0] },
    });

    const transaction = await sequelize.transaction();

    try {
      const group = await Group.create(
        { leader_id: leader.id, department_id: leader.department_id },
        { transaction }
      );

      for (const user of existingUsers) {
        await User.update(
          {
            has_group: true,
            group_id: group.id,
          },
          {
            where: { username: user.username },
            transaction,
          }
        );
      }

      await transaction.commit();
    } catch (error) {
      await transaction.rollback();
      throw error;
    }

    return res.json({
      success: true,
      message: "Group created successfully",
    });
  } catch (error) {
    console.error(error);
    return res.status(200).json({
      success: false,
      message: "An error occurred, please try again later",
    });
  }
};

exports.removeGroup = async (req, res) => {
  try {
    // const
  } catch (error) {
    console.error(error);
    return res.status(200).json({
      success: false,
      message: "An error occurred, please try again later",
    });
  }
};
exports.groupBulkUpload = async (req, res) => {
  const transaction = await sequelize.transaction();
  try {
    if (req.file == undefined) {
      return res.redirect(
        `/admin/students?error=${"Please Upload a Valid file"}`
      );
    }
    const path = "./libaries/" + req.file.filename;

    const students = await readXlsxFile(path);

    students.shift(); // skip header

    for (const student of students) {
      const leader = student[0];
      const members = student.slice(0, 21).filter(Boolean); // Filter out empty cells
      let hasError = false;
      const existingUsers = await User.findAll({
        attributes: ["username", "has_group"],
        where: {
          username: members,
          has_group: false,
        },
        raw: true,
      });

      for (const member of members) {
        const userExists = existingUsers.find(
          (existingUser) => existingUser.username === member
        );
        if (!userExists) {
          hasError = true;
        }
      }
      //? skip groups with issuess
      if (hasError) continue;

      const leaderUser = await User.findOne({
        where: { username: leader },
      });

      const group = await Group.create(
        {
          leader_id: leaderUser.id,
          department_id: leaderUser.department_id,
        },
        { transaction }
      );

      for (const user of existingUsers) {
        await User.update(
          {
            has_group: true,
            group_id: group.id,
          },
          {
            where: { username: user.username },
            transaction,
          }
        );
      }
    }

    // Commit the transaction only if there are no errors
    await transaction.commit();
    return res.status(200).json({
      success: true,
      message: `Group(s) Created Successfully!`,
    });
    fs.unlink(path, (err) => {
      if (err) console.log(err);
      else {
        console.log("\nDeleted file: " + req.file.originalname);
      }
    });

    return res.redirect(`/admin/students?success=true`);
  } catch (error) {
    console.log(error);
    await transaction.rollback();
    return res.redirect(
      `/admin/students?error=${"An error occurred while processing the file"}`
    );
  }
};
