const User = require("../../../models").users;
const Profile = require("../../../models").profiles;
const DocumentCategory = require("../../../models").document_categories;
const ProjectSubmission = require("../../../models").project_submissions;
const Department = require("../../../models").departments;
const ProjectTopic = require("../../../models").project_topics;
const Session = require("../../../models").sessions;
const { Op } = require("sequelize");

const env = process.env.NODE_ENV || "development";
// const config = require(__dirname + '/../../../config/config.json')[env];
const Sequelize = require("sequelize");

const sequelize = require("../../../config/connection");

exports.viewStudentProject = async (req, res) => {
  try {
    const { docId } = req.params;
    const doc = await ProjectSubmission.findOne({
      where: {
        id: docId,
      },
      raw: true,
    });
    res.render("admin/staffViewTemplate.ejs", {
      doc,
      user: req.user,
      error: false,
    });
  } catch (error) {
    console.log(error);
    return res.render("admin/staffViewTemplate.ejs", {
      user: req.user,
      error: error.message,
      content: "",
    });
  }
};

exports.projects = async (req, res) => {
  try {
    const { username } = req.query;
    let query = {};
    const departments = await Department.findAll({ where: { active: true } });
    let [projectInprogress] =
      await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress FROM project_submissions 
      INNER JOIN project_topics ON project_submissions.project_id  = project_topics.id 
      WHERE document_category_id <> '7' `);

    let [projectRejected] =
      await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress FROM project_submissions 
      INNER JOIN project_topics ON project_submissions.project_id  = project_topics.id 
      WHERE project_submissions.active = '0'`);

    let [projectCompleted] =
      await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress 
      FROM project_submissions 
      INNER JOIN project_topics ON project_submissions.project_id = project_topics.id
      WHERE document_category_id = '7'`);
    let projects = [];

    if (username) {
      const user = await User.findOne({ where: { username }, raw: true });
      query.student_user_id = user.id;
    }
    const topics = await ProjectTopic.findAll({
      where: {
        active: true,
        is_approved: true,
        ...query,
      },
      limit: 500,
      include: [
        {
          model: ProjectSubmission,
          require: true,
          where: { document_category_id: 7 },
          include: [
            {
              model: DocumentCategory,
              attributes: ["name"],
            },
            {
              model: ProjectTopic,
              include: [
                {
                  model: User,
                  as: "student",
                  attributes: ["username"],
                  include: [
                    {
                      model: Profile,
                      attributes: ["firstname", "lastname", "middlename"],
                    },
                  ],
                },
              ],
            },
          ],
        },
      ],
    });
    for (const topic of topics) {
      projects = [...projects, ...topic.project_submissions];
    }
    const sessions = await Session.findAll();
    return res.render("admin/projects.ejs", {
      error: false,
      user: req.user,
      departments,
      projectInprogress,
      projectCompleted,
      projectRejected,
      sessions,
      projects: JSON.parse(JSON.stringify(projects)),
    });
  } catch (error) {
    console.log(error);
    return res.render("admin/projects.ejs", {
      user: req.user,
      error: error.message,
      departments: [],
      projectInprogress: 0,
      projectCompleted: 0,
      projectRejected: 0,
      projects: [],
    });
  }
};
