const User = require("../../../models").users;
const Roles = require("../../../models").roles;
const CryptoJS = require("crypto-js");
const Session = require("../../../models").sessions;

exports.adminUser = async (req, res) => {
  try {
    let allRoles = [];
    const roles = await Roles.findAll({ where: { active: true } });
    for (const role of roles) {
      const userCount = await User.count({
        where: {
          second_role: role.id,
        },
      });
      allRoles.push({
        role: role.alias,
        count: userCount,
      });
    }
    const sessions = await Session.findAll({ raw: true });
    return res.render("admin/roles.ejs", {
      user: req.user,
      roles: allRoles,
      sessions,
    });
  } catch (error) {
    console.log(error);
    return res.status(500).send({ success: false, message: error.message });
  }
};
