const { includes } = require("lodash");
const noticeEmail = require("../../helpers/noticeEmail");
const Profile = require("../../../models").profiles;
const User = require("../../../models").users;
const Session = require("../../../models").sessions;

exports.schoolSettings = async (req, res) => {
  try {
    const sessions = await Session.findAll({ raw: true });
    return res.render("admin/index.ejs", {
      user: req.user,
      error: false,
      sessions,
    });
  } catch (error) {
    return res.render("admin/index.ejs", {
      user: req.user,
      error: error.message,
    });
  }
};

exports.sendNoticeMail = async (req, res) => {
  try {
    const users = await Profile.findAll({
      where: { role_id: 6 },
      include: [{ model: User }],
    });
    for (const user of JSON.parse(JSON.stringify(users))) {
      if (user?.user?.email) {
        console.log(user.user.email);
        console.log(user.firstname);

        const sendRestEmail = await noticeEmail(
          user.user.email,
          user.firstname
        );
      }
    }
    return res.status(200).send({ success: true, message: "mail sent" });
  } catch (error) {
    console.log(error);
    return res.status(500).send({ success: false, message: error.message });
  }
};
