const User = require("../../models").users;
const ActivityLog = require("../../models").activity_log;
const Level = require("../../models").levels;
const Department = require("../../models").departments;
const Institute = require("../../models").institutes;
const SchoolSessions = require("../../models").sessions;

function timeSince(date) {
  var seconds = Math.floor((new Date() - date) / 1000);

  var interval = seconds / 31536000;

  if (interval > 1) {
    return Math.floor(interval) + " years";
  }
  interval = seconds / 2592000;
  if (interval > 1) {
    return Math.floor(interval) + " months";
  }
  interval = seconds / 86400;
  if (interval > 1) {
    return Math.floor(interval) + " days";
  }
  interval = seconds / 3600;
  if (interval > 1) {
    return Math.floor(interval) + " hours";
  }
  interval = seconds / 60;
  if (interval > 1) {
    return Math.floor(interval) + " minutes";
  }
  return Math.floor(seconds) + " seconds";
}

exports.home = (req, res) => {
  return res.render("index.ejs");
};

exports.studentLogin = (req, res) => {
  return res.render("login/student.ejs", {
    error: false,
    success: {
      message: undefined,
    },
  });
};

exports.staffLogin = (req, res) => {
  return res.render("login/staff.ejs", {
    error: false,
    success: {
      message: undefined,
    },
  });
};

exports.profile = async (req, res) => {
  try {
    const user = await User.findOne({
      where: { id: req.user.id },
      attributes: [
        "department_id",
        "firstname",
        "lastname",
        "middlename",
        "photo_path",
        "email",
        "phone",
      ],
      include: [
        {
          model: Department,
          attributes: ["id", "name"],
          include: [
            {
              model: Institute,
              attributes: ["name"],
            },
          ],
        },
      ],
    });
    const logs = [];
    const activityLog = await ActivityLog.findAll({
      where: { causer_id: req.user.username },
      limit: 7,
      order: [["createdAt", "DESC"]],
      attributes: ["createdAt", "description"],
    });
    for (const act of activityLog) {
      const timeAgo = timeSince(act.createdAt);
      logs.push({ description: act.description, createdAt: timeAgo });
    }
    const sessions = await SchoolSessions.findOne({
      where: { id: req.user.session_id },
    });
    return res.render("login/profile.ejs", {
      userType: req.type,
      user: req.user,
      subscriptions: req.subscriptions,
      profile: user,
      activityLog: logs,
      sessions,
    });
  } catch (error) {
    console.log(error);
    return res.render("login/profile.ejs", {
      user: req.user,
      profile: {},
      subscriptions: req.subscriptions,
      error: error.message,
      activityLog: {},
      sessions: {},
    });
  }
};
exports.profile2 = async (req, res) => {
  try {
    let user = await User.findOne({
      where: { id: req.user.id },
      attributes: [
        "department_id",
        "firstname",
        "lastname",
        "middlename",
        "photo_path",
        "username",
        "email",
        "password",
        "phone",
      ],
      include: [
        {
          model: Department,
          attributes: ["id", "name"],
          include: [
            {
              model: Institute,
              attributes: ["name"],
            },
          ],
        },
      ],
    });
    user = JSON.parse(JSON.stringify(user));
    // console.log(user)
    const sessions = await SchoolSessions.findOne({
      where: { id: req.user.session_id },
    });
    return res.render("login/change_password.ejs", {
      userType: req.type,
      user: user,
      profile: user,
      subscriptions: req.subscriptions,
      sessions,
    });
  } catch (error) {
    console.log(error);
    return res.render("login/profile.ejs", {
      user: req.user,
      profile: {},
      subscriptions: req.subscriptions,
      error: error.message,
      activityLog: {},
      sessions: {},
    });
  }
};
exports.profile3 = async (req, res) => {
  return res.render("login/pay.ejs", {
    user: req.user,
    subscriptions: req.subscriptions,
  });
};
