const User = require("../../models").users;
const Activity = require("../helpers/activity.helper");
const Profile = require("../../models").profiles;
const StudentSupervisor = require("../../models").student_supervisors;

exports.Edit = async (req, res) => {
  try {
    const { supervisor, phone, email, department_id } = req.body;

    const updateUser = await User.update(
      { email, phone, department_id },
      {
        where: {
          id: req.body.user_id,
        },
      }
    );

    if (supervisor) {
      await StudentSupervisor.update(
        { lecturer_user_id: supervisor },
        { where: { student_user_id: req.body.user_id } }
      );
    }
    const saveActivity = await Activity(
      "Profile",
      "Update profile information",
      req.body.firstname
    );

    if (updateUser && saveActivity) {
      return res.status(200).send({
        statusCode: "200",
        success: true,
        message: "Your information has been updated",
      });
    } else {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: "Error",
        error: `unabale to update your information, try again`,
      });
    }
  } catch (e) {
    console.log(e);
    res.status(500).send({
      statusCode: "500",
      success: false,
      message: "Error",
      error: e.message,
    });
  }
};
exports.Profile = async (req, res) => {
  return res.render("student/profile.ejs");
};

exports.getStarted = async (req, res) => {
  try {
    const { email, phone, username, supervisor, department_id } = req.body;

    if (!email) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: "Error",
        error: "email is required",
      });
    }
    if (!supervisor) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: "Error",
        error: "Supervisor is required",
      });
    }
    if (!phone) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: "Error",
        error: "phone is required",
      });
    }
    if (req.file == undefined) {
      return res.status(400).send("Please upload an valid file!");
    }
    let path = req.file.filename;
    const updateUserData = {
      email: email.toLowerCase().trim(),
      phone,
      first_login: true,
      photo_path: path,
      department_id,
    };

    const updateUser = await User.update(updateUserData, {
      where: {
        username,
      },
    });
    const mainUser = await User.findOne({
      where: { username: username },
      attributes: ["id"],
    });

    await StudentSupervisor.update(
      { supervisor_name: supervisor },
      { where: { student_user_id: mainUser.id } }
    );

    const saveActivity = await Activity(
      "Profile",
      "First time setup",
      username
    );

    if (updateUser && saveActivity) {
      return res.status(200).send({
        statusCode: "200",
        success: true,
        message: "Your information has been updated",
      });
    } else {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: "Error",
        error: `unabale to update your information, try again`,
      });
    }
  } catch (e) {
    console.log(e);
    res.status(500).send({
      statusCode: "500",
      success: false,
      message: "Error",
      error: e.message,
    });
  }
};
exports.uploadPassport = async (req, res) => {
  try {
    const { username } = req.body;

    if (req.file == undefined) {
      return res.status(400).send("Please upload an valid file!");
    }
    let path = req.file.filename;

    await User.update({ photo_path: path }, { where: { username: username } });

    await Activity("Profile", "Passport Updated!", username);

    return res.status(200).send({
      statusCode: "200",
      success: true,
      message: "Your information has been updated",
    });
  } catch (e) {
    console.log(e);
    res.status(500).send({
      statusCode: "500",
      success: false,
      message: "Error",
      error: e.message,
    });
  }
};
