const User = require("../../models").users;
const Profile = require("../../models").profiles;
const Project = require("../../models").projects;
const ProjectSubmission = require("../../models").project_submissions;
const Level = require("../../models").levels;
const StudyMode = require("../../models").study_modes;
const ProjectType = require("../../models").project_types;
const ProjectTopic = require("../../models").project_topics;
const Department = require("../../models").departments;
const Institute = require("../../models").institutes;
const Session = require("../../models").sessions;
const StudentSupervisor = require("../../models").student_supervisors;
const DocumentCategory = require("../../models").document_categories;
const CryptoJS = require("crypto-js");
var key = CryptoJS.enc.Base64.parse("4gt71TxD1e4P3433");
var iv  = CryptoJS.enc.Base64.parse("4gt71TxD1e4P3433");
const ActivityLog = require("../../models").activity_log
const LibraryAccessCode = require("../../models").library_access_codes;
const {
viewResearch
} = require("./researchLibrary");
const {Op} = require("sequelize");

const env = process.env.NODE_ENV || 'development';
// const config = require(__dirname + '/../../config/config.json')[env];
const Sequelize = require('sequelize');

const sequelize  = require("../../config/connection");
exports.staffDashboard = async (req, res) => {
    try {
        const departments = await Department.findAll({where:{active:true}})

        let  [projectInprogress] = await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress FROM project_submissions 
        INNER JOIN project_topics ON project_submissions.project_id  = project_topics.id 
        WHERE document_category_id <> '7' AND lecturer_user_id = '${req.user.id}' `);

        let  [projectRejected] = await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress FROM project_submissions 
        INNER JOIN project_topics ON project_submissions.project_id  = project_topics.id 
        WHERE project_submissions.active = '0' AND lecturer_user_id = '${req.user.id}' `);

        let  [projectCompleted] = await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress 
        FROM project_submissions 
        INNER JOIN project_topics ON project_submissions.project_id = project_topics.id
        WHERE document_category_id = '7' AND lecturer_user_id = '${req.user.id}'
        `);
        let projects = [];
      const topics = await ProjectTopic.findAll({
        where:{lecturer_user_id:req.user.id, active:true,is_approved:true},
        include:[
            {model:ProjectSubmission,
              include:[
                {
                  model:DocumentCategory,
                  attributes:["name"]
                },
                {
                    model:ProjectTopic,
                    include:[
                        {
                            model:User,
                            as: "student",
                            attributes:["username"],
                            include: [
                              { 
                              model: Profile,
                              attributes:["firstname","lastname","middlename"],
                            },
                          ],
                            
                          },
                    ]
                }
              ]
            }
        ],
    });
    for(const topic of topics){
      projects = [...projects, ...topic.project_submissions]
    }
    return res.render("staff/staff_dashboard.ejs",{user: req.user, departments,projectInprogress,projectCompleted,projectRejected,projects:JSON.parse(JSON.stringify(projects))})
    } catch (error) {
        console.log(error)
    }
}

exports.researchLibrary = async (req, res) => {
    try {
        const { auth_code } = req.query;
        const data = await viewResearch(req, res);
        const departments = await Department.findAll({where:{active:true}});
        const sessions = await Session.findAll()
        // if(!accessType){
        // }
        if(req.user.role == 1 ){ 
          return res.render("staff/library.ejs", {user: req.user, projects:data.projects, departments, sessions})

        }else{
          if(!auth_code){
            return res.redirect("/staff-dashboard")
            
          }
          const user = await LibraryAccessCode.findOne({where:{access_code:auth_code,status:false}})
            if(user){
              await LibraryAccessCode.update({status:true, user_by: req.user.id}, {where:{access_code:auth_code}});
              return res.render("staff/researchLibrary.ejs", {user: req.user, error:false, projects:data.projects, departments, sessions})
            }else{
              return res.redirect("/staff-dashboard")
            }

        }
    } catch (error) {
        console.log(error)
    }
}

exports.myAssignStuent = async (req, res) => {
  try {
    let allStudents =[];
    let pendingApproval = 0;
    let totalND = 0;
    let totalHND = 0;
    let totalFT= 0;
    let totalPT = 0;

    const projectSubmission = await Project.findAll({
      where:{
        lecturer_user_id:req.user.id,
      },
      include:[{model:ProjectSubmission}]
    })
    for(const project of JSON.parse(JSON.stringify(projectSubmission))){
      if(project.project_submissions.is_approved === false)
        pendingApproval++
    }
    const students = await StudentSupervisor.findAll({
      where:{
        lecturer_user_id:req.user.id,
      },
      attributes:["student_user_id"]
    }) 
    for (const student of students){
      const user = await Profile.findOne({
        where:{user_id:student.student_user_id},
        attributes:["firstname","lastname","middlename","user_id"],
        include:[
          {
            model:User,
            attributes:["username","email","phone","id"]
          },
          {
            model:Level
          },
          {
            model:StudyMode
          }
        ],
      });
      if(JSON.parse(JSON.stringify(user))?.study_mode.name == "FULL TIME"){
        totalFT++;
      }
      if(JSON.parse(JSON.stringify(user))?.study_mode.name == "PART TIME"){
        totalPT++;
      }
      if(JSON.parse(JSON.stringify(user))?.level.name == "National Diploma"){
        totalND++;
      }
      if(JSON.parse(JSON.stringify(user))?.level.name == "Higher National Diploma"){
        totalHND++;
      }
      allStudents.push(user)
    }
    allStudents = JSON.parse(JSON.stringify(allStudents))
    return res.render("staff/assign_student.ejs", {
      user: req.user, 
      students:allStudents,
      subscriptions: req.subscriptions,
      error:false,
      pendingApproval,
      totalND,
      totalHND,
      totalFT,
      totalPT
    })
  } catch (error) {
    console.log(error)
    return res.render("staff/assign_student.ejs", {
      user: req.user, 
      students:[],
      subscriptions: req.subscriptions,
      error:error.message,
      totalND:0,
      totalHND:0,
      totalFT:0,
      totalPT:0
    })
  }
}

exports.topic = async (req, res) => {
  try {
    const pendingApprove = await ProjectTopic.count({where:{is_approved:false, active:true, lecturer_user_id:req.user.id}})
    const approved = await ProjectTopic.count({where:{is_approved:true, lecturer_user_id:req.user.id}})
    const rejected = await ProjectTopic.count({where:{active:false, lecturer_user_id:req.user.id, active:false}})
    const topics = await ProjectTopic.findAll({
        where:{
          active:true, 
          lecturer_user_id:req.user.id
        },
        include:[
          {
            model:User,
            as: "student",
            attributes:["username"],
            include:[
              {
                model:Profile,
                include:[
                  {
                    model:Level
                  },
                  {
                    model:StudyMode
                  }
                ]
              },
            ]
          },
          {
            model:ProjectType
          }
        ]
      })
      return res.render("staff/topic.ejs",{
        user: req.user, 
        pendingApprove,
        approved,
        rejected,
        topics,
        error:false
      })
  } catch (error) {
    return res.render("staff/topic.ejs",{
      user: req.user, 
      pendingApprove:0,
      approved:0,
      rejected:0,
      topics:[],
      error:error.message
    });
  }
}

exports.searchStudentProject = async (req, res) => {
    const {term} = req.query; 
    const projects = await Project.findAll({
        where:{
        lecturer_user_id: req.user.id,
        topic: {
            [Op.startsWith]: `${term}`
          },
        },
        attributes:["id","student_user_id","topic","createdAt","active","is_completed"],
        include:[
            {
              model:ProjectType,
              attributes:["name"],
            },
            {
              model:Profile,
              as: "student",
              attributes:["department_id","firstname","lastname","middlename","photo_path", "study_mode_id", "level_id", ],
              include: [
                { 
                model: User,
                attributes:["username"],
                username: {
                  [Op.startsWith]: `${term}`
                },
              },
              { 
                model: Department,
                attributes:["id","name"],
                include:[
                  { 
                    model: Institute,
                    attributes:["name"]
                  }
                ]
              }
                 ],
            where:{
                [Op.or]:[
                    {
                    firstname: {
                        [Op.startsWith]: `${term}`
                        },
                    lastname: {
                            [Op.startsWith]: `${term}`
                            },
                    middlename: {
                                [Op.startsWith]: `${term}`
                                },
                }
                    
                ]
            }
            },
          ]
    })

    return res.status(200).send(projects)
}
exports.getProjectStudentForLecturer = async (req, res) => {
    const {term,prop} = req.params;
    let projects = []
    if(!term)
        return res.status(400).send({success:false,message:"Term is required!"})
    if(prop == "level"){
        projects = await ProjectSubmission.findAll({
          include:[
              {
                model:DocumentCategory,
                attributes:["name"]
              },
              {
                  model:Project,
                  where:{
                    lecturer_user_id: req.user.id,
                    },
                    attributes:["id","student_user_id","topic","createdAt","active","is_completed"],
                    include:[
                        {
                          model:ProjectType,
                          attributes:["name"],
                        },
                        {
                          model:User,
                          as: "lecturer",
                          include:[
                            {
                              model:Profile,
                              attributes:["department_id","firstname","lastname","middlename"],
                            }
                          ]
                        },
                        {
                          model:User,
                          as: "student",
                          include:[
                            {
                              model:Profile,                          
                              attributes:["department_id","firstname","lastname","middlename","photo_path", "study_mode_id", "level_id", ],
                              include: [
                                { 
                                  model: Department,
                                  attributes:["id","name"],
                                  include:[
                                    { 
                                      model: Institute,
                                      attributes:["name"]
                                    }
                                  ]
                                }
                                  ],
                              where:{
                                  level_id:term,
                              }

                            }
                          ]
                        },
                      ]
              }
            ]
      }); 
    }
    if(prop == "study_mode"){
         projects = await ProjectSubmission.findAll({
          include:[
              {
                model:DocumentCategory,
                attributes:["name"]
              },
              {
                  model:Project,
                  where:{
                    lecturer_user_id: req.user.id,
                    },
                    attributes:["id","student_user_id","topic","createdAt","active","is_completed"],
                    include:[
                        {
                          model:ProjectType,
                          attributes:["name"],
                        },
                        {
                          model:Profile,
                          as: "lecturer",
                          attributes:["department_id","firstname","lastname","middlename"],
                        },
                        {
                          model:Profile,
                          as: "student",
                          attributes:["department_id","firstname","lastname","middlename","photo_path", "study_mode_id", "level_id", ],
                          include: [
                            { 
                            model: User,
                            attributes:["username"]
                          },
                          { 
                            model: Department,
                            attributes:["id","name"],
                            include:[
                              { 
                                model: Institute,
                                attributes:["name"]
                              }
                            ]
                          }
                             ],
                        where:{
                            study_mode_id:term,
                        }
                        },
                      ]
              }
            ]
      });  
    }
    if(prop == "projectTye"){
         projects = await ProjectSubmission.findAll({
          include:[
              {
                model:DocumentCategory,
                attributes:["name"]
              },
              {
                  model:Project,
                  where:{
                    lecturer_user_id: req.user.id,
                    },
                    attributes:["id","student_user_id","topic","createdAt","active","is_completed"],
                    include:[
                        {
                          model:ProjectType,
                          attributes:["name","id"],
                          where:{id:term}
                        },
                        {
                          model:Profile,
                          as: "lecturer",
                          attributes:["department_id","firstname","lastname","middlename"],
                        },
                        {
                          model:Profile,
                          as: "student",
                          attributes:["department_id","firstname","lastname","middlename","photo_path", "study_mode_id", "level_id", ],
                          include: [
                            { 
                            model: User,
                            attributes:["username"]
                          },
                          { 
                            model: Department,
                            attributes:["id","name"],
                            include:[
                              { 
                                model: Institute,
                                attributes:["name"]
                              }
                            ]
                          }
                             ],
                        },
                      ]
              }
            ]
      });   
    }
    if(prop == "status"){
     projects = await ProjectSubmission.findAll({
      include:[
          {
            model:DocumentCategory,
            attributes:["name"]
          },
          {
              model:Project,
              where:{
                lecturer_user_id: req.user.id,
                is_completed:Boolean(term),
                },
                attributes:["id","student_user_id","topic","createdAt","active","is_completed"],
                include:[
                    {
                      model:ProjectType,
                      attributes:["name"],
                    },
                    {
                      model:Profile,
                      as: "lecturer",
                      attributes:["department_id","firstname","lastname","middlename"],
                    },
                    {
                      model:Profile,
                      as: "student",
                      attributes:["department_id","firstname","lastname","middlename","photo_path", "study_mode_id", "level_id", ],
                      include: [
                        { 
                        model: User,
                        attributes:["username"]
                      },
                      { 
                        model: Department,
                        attributes:["id","name"],
                        include:[
                          { 
                            model: Institute,
                            attributes:["name"]
                          }
                        ]
                      }
                         ],
                    },
                  ]
          }
        ]
  });   
    }
    return res.status(200).send(projects)
};
exports.studentManagemt = async (req, res) =>{
  let err = false;
  let success = false
  if(req.query.error)
    err = req.query.error
  if(req.query.success)
  success = true
  const department_id = req.department_id;
  const session = await Session.findOne({where:{status:true}})
  const supervisors = await Profile.findAll({where:{department_id,role_id:6}})
  const departments = await Department.findAll({where:{active:true}})
  const department = await Department.findByPk(department_id)
  const totalND = await Profile.count({where:{department_id, level_id:1 ,session_id:session.id,role_id:7}})
  const totalHND = await Profile.count({where:{department_id, level_id:2 ,session_id:session.id,role_id:7}})
  const totalFT= await Profile.count({where:{department_id, study_mode_id:1 ,session_id:session.id},role_id:7})
  const totalPT = await Profile.count({where:{department_id, study_mode_id:2,session_id:session.id,role_id:7 }})

  const student = await Profile.findAll({where:{
      department_id,
      session_id:session.id,
      role_id:7
      },
      order:[["createdAt","DESC"]],
      include:[
        { 
          model: User,
          attributes:["username","email","phone","id"]
        },
        {
          model:StudyMode
        },
        {
          model:Level
        }
        ]
  })
  return res.render("staff/student_management.ejs",
    {
      success,
      err,
      supervisors:JSON.parse(JSON.stringify(supervisors)),
      students:JSON.parse(JSON.stringify(student)),
      departments, 
      department,
      totalND, 
      totalHND,
      totalFT,
      totalPT,
      user: req.user,
    })

};

exports.studentManagemtFilter = async (req, res) =>{
  let {term,prop} = req.params
  const department_id = req.department_id;
  const session = await Session.findOne({where:{status:true}});
  let student = []
  if(prop == "study_mode"){
    student = await Profile.findAll({where:{
      department_id,
      session_id:session.id,
      study_mode_id:term
      },
      include:[
        { 
          model: User,
          attributes:["username","email","phone"]
        },
        {
          model:StudyMode
        },
        {
          model:Level
        }
        ]
    })
  }else{
    student = await Profile.findAll({where:{
      department_id,
      session_id:session.id,
      level_id:term
      },
      include:[
        { 
          model: User,
          attributes:["username","email","phone"]
        },
        {
          model:StudyMode
        },
        {
          model:Level
        }
        ]
    })
  }
  
 return res.send(JSON.parse(JSON.stringify(student)))

};

exports.studentManagemtSearchFilter = async (req, res) =>{
  const {term} = req.params;
  const department_id = req.department_id;
  const session = await Session.findOne({where:{status:true}})

  const student = await Profile.findAll({where:{
      department_id,
      session_id:session.id
      },
      where:{
        [Op.or]:[
            {
              firstname: {
                  [Op.startsWith]: `${term}`
                  },
              lastname: {
                      [Op.startsWith]: `${term}`
                      },
              middlename: {
                          [Op.startsWith]: `${term}`
                          },
          }
              
          ]
      },
      include:[
        { 
          model: User,
          attributes:["username","email","phone"],
          where:{
            [Op.or]:[
              {
                username: {
                  [Op.startsWith]: `${term}`
                  },
                  email: {
                      [Op.startsWith]: `${term}`
                      },
                      phone: {
                          [Op.startsWith]: `${term}`
                          },
          }
              
          ]
          }
        },
        {
          model:StudyMode
        },
        {
          model:Level
        }
        ]
  })
  return res.send(JSON.parse(JSON.stringify(student)))

};

exports.approveTopic = async (req, res) => {
  try {
    const { 
      id, 
      message,
      student_id, 
      actionType,
      project_type_id,
      topicUpdate
     } = req.body
    let updateTopic;
    if(actionType === 'accept'){
      await ProjectTopic.update({is_approved:false,active:false,},{where:{student_user_id:student_id, lecturer_user_id:req.user.id,project_type_id}});  
      updateTopic = await ProjectTopic.update({is_approved:true, active:true, approval_comment:message},{where:{id}});
      return res.status(200).send({success:true,message:"Topic successfully approved"});
    }else if(actionType === 'reject'){
      updateTopic = await ProjectTopic.update({active:false, approval_comment:message},{where:{id}});
      return res.status(200).send({success:true,message:"Topic successfully rejected"});
    }else if(actionType === 'edit'){
      await ProjectTopic.update({is_approved:false,active:false,},{where:{student_user_id:student_id, lecturer_user_id:req.user.id,project_type_id}});  
      updateTopic = await ProjectTopic.update({is_approved:true, active:true, approval_comment:message,topic:topicUpdate},{where:{id}});
      return res.status(200).send({success:true,message:"Topic successfully updated and approved"});

    }
  } catch (error) {
    return res.status(500).send({success:false, message:error.message});
  }
};

exports.studentProject = async (req, res) => {
  try {
      const departments = await Department.findAll({where:{active:true}})
      let  [projectInprogress] = await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress FROM project_submissions 
        INNER JOIN project_topics ON project_submissions.project_id  = project_topics.id 
        WHERE document_category_id <> '7' AND lecturer_user_id = '${req.user.id}' `);

        let  [projectRejected] = await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress FROM project_submissions 
        INNER JOIN project_topics ON project_submissions.project_id  = project_topics.id 
        WHERE project_submissions.active = '0' AND lecturer_user_id = '${req.user.id}' `);

        let  [projectCompleted] = await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress 
        FROM project_submissions 
        INNER JOIN project_topics ON project_submissions.project_id = project_topics.id
        WHERE document_category_id = '7' AND lecturer_user_id = '${req.user.id}'
        `);
      let projects = [];
      const topics = await ProjectTopic.findAll({
        where:{lecturer_user_id:req.user.id, active:true,is_approved:true},
        include:[
            {model:ProjectSubmission,
              include:[
                {
                  model:DocumentCategory,
                  attributes:["name"]
                },
                {
                    model:ProjectTopic,
                    include:[
                        {
                            model:User,
                            as: "student",
                            attributes:["username"],
                            include: [
                              { 
                              model: Profile,
                              attributes:["firstname","lastname","middlename"],
                            },
                          ],
                            
                          },
                    ]
                }
              ]
            }
        ],
    });
    for(const topic of topics){
      projects = [...projects, ...topic.project_submissions]
    }
  return res.render("staff/project.ejs",{error:false,user: req.user, departments,projectInprogress,projectCompleted,projectRejected,projects:JSON.parse(JSON.stringify(projects))})
  } catch (error) {
      console.log(error)
      return res.render("staff/project.ejs",{
        user: req.user, 
        error:error.message,
        departments:[],
        projectInprogress:0,
        projectCompleted:0,
        projectRejected:0,
        projects:[]
  });
}
}
exports.viewStudentProject = async (req, res) => {
  try {
    const { docId } = req.params;
    const doc = await ProjectSubmission.findOne({
        where:{
            id:docId
        },
        raw:true
    })
    res.render('staffViewTemplate.ejs', { doc, user:req.user, error:false});
  } catch (error) {
      console.log(error)
      return res.render("staff/view_project.ejs",{
        user: req.user, 
        error:error.message,
        content:""
  });
}
}
exports.approveDocument = async (req, res) => {
  try {
    const { 
      docId, 
      message,
      actionType,
     } = req.body
    let updateTopic;
    const projectSubmission = await ProjectSubmission.findOne({where:{
      id:docId
    },
    raw:true
  });
    if(actionType === 'accept'){
      updateTopic = await ProjectSubmission.update({is_approved:true, active:true, approval_comment:message},{where:{id:docId}});
      if(projectSubmission.document_category_id == 7){
        await Project.update({is_completed:true,active:true},{where:{id:projectSubmission.project_id}})
      }
      return res.status(200).send({success:true,message:"Document successfully approved"});
    }else{
      updateTopic = await ProjectSubmission.update({active:false,is_approved:false, approval_comment:message},{where:{id:docId}});
      return res.status(200).send({success:true,message:"Document successfully rejected"});
    }
  } catch (error) {
    return res.status(500).send({success:false, message:error.message});
  }
};
exports.profile = async (req, res) => {
  let type = req.query.type;
  try {
      let user = {};
      let supervisoDetails = {};
      const user_id = req.query.user_id
      const findUser = await User.findByPk(user_id)
      if(type == "student"){
           user = await Profile.findOne({
            where:{user_id},
            attributes:["user_id","department_id","firstname","lastname","middlename","photo_path"],
            include: [
              { 
              model: User,
              attributes:["username","email","phone","slug"]
            },
            {
              model:StudyMode
            },
            {
              model:Level
            },
            { 
              model: Department,
              attributes:["id","name"],
              include:[
                { 
                  model: Institute,
                  attributes:["name"]
                }
              ]
            }
          ],
          });
      }else{
        user = await Profile.findOne({
          where:{user_id},
          attributes:["user_id","department_id","firstname","lastname","middlename","photo_path"],
          include: [
            { 
            model: User,
            attributes:["username","email","phone","slug"]
          },
          { 
            model: Department,
            attributes:["id","name"],
            include:[
              { 
                model: Institute,
                attributes:["name"]
              }
            ]
          }
        ],
        });
      }
      const study_modes = await StudyMode.findAll({});
      const levels = await Level.findAll({});
      var decrypted = (CryptoJS.AES.decrypt(findUser.password, key, {iv: iv})).toString(CryptoJS.enc.Utf8);
      const supervisoDetailsStudentSupervisor = await StudentSupervisor.findOne({
        where: {
            student_user_id: user_id
        },
      });
      if(supervisoDetailsStudentSupervisor){

      supervisoDetails = await Profile.findOne({
        where: {
            user_id: JSON.parse(JSON.stringify(supervisoDetailsStudentSupervisor)).lecturer_user_id
        }
     })
      }
     const supervisors = await Profile.findAll({where:{role_id:6,department_id:user.department_id}});
      const logs = [];
      const activityLog = await ActivityLog.findAll({
          where:{causer_id:findUser.id},
          limit:7,
          order:[["createdAt","DESC"]],
          attributes:["createdAt","description"]
      });
      for(const act of activityLog){
          const timeAgo = timeSince(act.createdAt)
          logs.push({description:act.description, createdAt:timeAgo})
      }
      return res.render("staff/profile.ejs", {
        user: req.user, 
        subscriptions: req.subscriptions,
        study_modes,
        password:decrypted,
        levels,userType:"staff",user:findUser,supervisoDetails, profile:user,supervisors, activityLog:logs, error:false})
  } catch (error) {
    console.log(error)
      return res.render("staff/profile.ejs",{
          user: req.user,
          subscriptions: req.subscriptions,
          profile: {},
          subscriptions: req.subscriptions,
          error: error.message,
          activityLog:{},
          supervisors:[],
          levels:[],
          study_modes:[],
          supervisoDetails:{},
          userType:"staff",
          activityLog:"",
      })
  }
};
exports.profile2 = async (req, res) => {

  let type = req.query.type;
    try {
      let supervisoDetails = {}
      const user_id = req.query.user_id
      const findUser = await User.findByPk(user_id)
      const user = await Profile.findOne({
        where:{user_id},
        attributes:["user_id","department_id","firstname","lastname","middlename","photo_path"],
        include: [
          { 
          model: User,
          attributes:["username","email","phone","slug"]
        },
        { 
          model: Department,
          attributes:["id","name"],
          include:[
            { 
              model: Institute,
              attributes:["name"]
            }
          ]
        },
        {
          model:StudyMode
        },
        {
          model:Level
        }
      ],
    });

    const study_modes = await StudyMode.findAll({});
    const levels = await Level.findAll({});
    const supervisoDetailsStudentSupervisor = await StudentSupervisor.findOne({
      where: {
          student_user_id: user_id
      },
    });
    if(supervisoDetailsStudentSupervisor){

      supervisoDetails = await Profile.findOne({
        where: {
            user_id: JSON.parse(JSON.stringify(supervisoDetailsStudentSupervisor)).lecturer_user_id
        }
    })
    }
  var decrypted = (CryptoJS.AES.decrypt(findUser.password, key, {iv: iv})).toString(CryptoJS.enc.Utf8);
  const supervisors = await Profile.findAll({where:{role_id:6,department_id:user.department_id}});
    return res.render("staff/change_password.ejs",  {
      user: req.user, 
      userType:"staff",
      password: decrypted,
      subscriptions: req.subscriptions,
      supervisoDetails,
      user:findUser,
      profile:user,
      supervisors,
      study_modes,
      levels
    })
  } catch (error) {
    console.log(error)
      return res.render("staff/profile.ejs",{
          user: req.user,
          profile: {},
          subscriptions: req.subscriptions,
          error: error.message,
          activityLog:{},
          supervisors:[],
          supervisors:[],
          study_modes:[],
          levels:[],
          supervisoDetails:{},
          userType:"staff",
          activityLog:[]
      })
  }
};
exports.accessManagement = async (req, res) => {
  try {
      const otps = await LibraryAccessCode.findAll({
        order:[["createdAt","DESC"]],
        include:[
          {
            model:User,
            as:"usedBy",
          },
          {
            model:User,
            as:"createdBy",
          }
        ]
      })
      const totalActiveOTP = await LibraryAccessCode.count({where:{status:false}})
      const totalInActiveOTP = await LibraryAccessCode.count({where:{status:true}})
      return res.render("admin/library_access.ejs", {
          error:false,
          success:false,
          subscriptions:req.subscriptions,
          user:req.user,
          otps,
          totalActiveOTP,
          totalInActiveOTP
      })
  } catch (error) {
      console.log(error)
      return res.render("admin/library_access.ejs", {
          error:error.message,
          subscriptions:req.subscriptions,
          user:req.user,
          otps:[],
          totalActiveOTP:0,
          totalInActiveOTP:0
      })
  }
};
exports.getTopicById =  async (req, res) => {
  const {id} = req.params
  try {
    const topic = await ProjectTopic.findOne({where:{id}, raw:true});
    return res.status(200).send({success:true, topic})
  } catch (error) {
    return res.status(500).send({success:false, message:error.message})
  }
}

exports.allProjects =  async (req, res) =>{
  try {
    const {username} = req.query;
    let query = {};
    const departments = await Department.findAll({where:{active:true}})
    let  [projectInprogress] = await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress FROM project_submissions 
      INNER JOIN project_topics ON project_submissions.project_id  = project_topics.id 
      WHERE document_category_id <> '7' `);

      let  [projectRejected] = await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress FROM project_submissions 
      INNER JOIN project_topics ON project_submissions.project_id  = project_topics.id 
      WHERE project_submissions.active = '0'`);

      let  [projectCompleted] = await sequelize.query(`SELECT count(project_submissions.id) AS projectInprogress 
      FROM project_submissions 
      INNER JOIN project_topics ON project_submissions.project_id = project_topics.id
      WHERE document_category_id = '7'`);
    let projects = [];

    if(username){
      const user = await User.findOne({where:{username}, raw:true});
      query.student_user_id = user.id
    }
    const topics = await ProjectTopic.findAll({
      where:{ 
        active:true,
        is_approved:true,
        ...query
      },
      limit:500,
      include:[
          {model:ProjectSubmission,
            require:true,
            where:{document_category_id:7},
            include:[
              {
                model:DocumentCategory,
                attributes:["name"]
              },
              {
                  model:ProjectTopic,
                  include:[
                      {
                          model:User,
                          as: "student",
                          attributes:["username"],
                          include: [
                            { 
                            model: Profile,
                            attributes:["firstname","lastname","middlename"],
                          },
                        ],
                          
                        },
                  ]
              }
            ]
          }
      ],
  });
  for(const topic of topics){
    projects = [...projects, ...topic.project_submissions]
  }
return res.render("staff/qa-project.ejs",
{error:false,
  user: req.user, 
  departments,
  projectInprogress,
  projectCompleted,
  projectRejected,
  projects:JSON.parse(JSON.stringify(projects))})
} catch (error) {
    console.log(error)
    return res.render("admin/projects.ejs",{
      user: req.user, 
      error:error.message,
      departments:[],
      projectInprogress:0,
      projectCompleted:0,
      projectRejected:0,
      projects:[]
});
}
};