const User = require("../../models").users;
const Profile = require("../../models").profiles;
const Project = require("../../models").projects;
const ProjectSubmission = require("../../models").project_submissions;
const StudentSupervisor = require("../../models").student_supervisors;
const ProjectTopic = require("../../models").project_topics;
const Packages = require("../../models").packages;
const Subcriptions = require("../../models").subscriptions;
const Siwes = require("../../models").siwes;
const Department = require("../../models").departments;
const Institute = require("../../models").institutes;
const Study_modes = require("../../models").study_modes;
const PaystackDetails = require("../../models").paystack_details;
const Bindingpayment = require("../../models").binding_payments;
const paymentHistory = require("../../models").payment_history;
const ProjectType = require("../../models").project_types;
const DocumentCategory = require("../../models").document_categories;
const SchoolSessions = require("../../models").sessions;
const { Op, where } = require("sequelize");
const qr = require("qrcode");
const { GoogleAuth } = require("google-auth-library");
const { google } = require("googleapis");
const fs = require("fs");
const mime = require("mime");
const { verifyPayment } = require("./paystack-transaction-init.controller");

exports.studentDashboard = async (req, res) => {
  try {
    console.log(req.user.department_id);
    if (req.user.first_login == false || !req.user.department_id)
      return res.redirect(
        "/user/get-started?corass-pro-d=" +
          req.user.id +
          "&id=" +
          req.user.username
      );
    let pendingProj = 0;
    let approvedProj = 0;
    let rejectedProj = 0;
    let allSubProject = [];
    let allTopic = [];
    let isReady = false;
    const myTopic = await ProjectTopic.findOne({
      where: {
        student_user_id: req.user.id,
        active: true,
        is_approved: true,
      },
      raw: true,
    });

    if (myTopic) {
      allSubProject = await ProjectSubmission.findAll({
        where: {
          project_id: myTopic.id,
        },
      });
      pendingProj = await ProjectSubmission.count({
        where: {
          active: true,
          project_id: myTopic.id,
          is_approved: false,
        },
      });
      approvedProj = await ProjectSubmission.count({
        where: {
          active: true,
          project_id: myTopic.id,
          is_approved: true,
        },
      });
      rejectedProj = await ProjectSubmission.count({
        where: {
          active: false,
          project_id: myTopic.id,
        },
      });
    }
    const topicApproved = await ProjectTopic.count({
      where: {
        active: true,
        student_user_id: req.user.id,
        is_approved: true,
      },
    });
    const topics = await ProjectTopic.findAll({
      where: {
        active: true,
        student_user_id: req.user.id,
      },
      raw: true,
    });
    const approveTopic = await ProjectTopic.findOne({
      where: {
        is_approved: true,
        active: true,
        student_user_id: req.user.id,
      },
      raw: true,
    });
    if (approveTopic) {
      const project = await ProjectSubmission.findOne({
        where: {
          document_category_id: 7,
          project_id: approveTopic.id,
          is_approved: true,
          active: true,
        },
        raw: true,
      });

      if (project) isReady = true;
    }

    const sessions = await SchoolSessions.findOne({
      where: { id: req.user.session_id },
    });

    return res.render("student/student_dashboard.ejs", {
      user: req.user,
      error: false,
      pendingProj,
      approvedProj,
      rejectedProj,
      allDoc: JSON.parse(JSON.stringify(allSubProject)).length,
      topics,
      topicApproved,
      subscriptions: req.subscriptions,
      isReady,
      sessions,
    });
  } catch (error) {
    console.log(error);
    return res.render("student/student_dashboard.ejs", {
      user: req.user,
      error: error.message,
      pendingProj: 0,
      profile: {},
      topicApproved: 0,
      approvedProj: 0,
      rejectedProj: 0,
      allDoc: 0,
      topics: [],
      supervisoDetails: {},
      subscriptions: req.subscriptions,
      sessions,
    });
  }
};
exports.studentProjectBindingDashboard = async (req, res) => {
  try {
    let pendingProj = 0;
    let approvedProj = 0;
    let rejectedProj = 0;
    let allSubProject = [];
    let allTopic = [];

    const { trxref } = req.query;

    if (trxref) await verifyPayment(trxref);

    const allProjects = await Project.findAll({
      where: {
        active: true,
        student_user_id: req.user.id,
      },
    });
    const bindingPayment = await Bindingpayment.findOne({
      where: { user_id: req.user.id, txn_status: "success" },
    });
    for (const project of allProjects) {
      const getsubProj = await ProjectSubmission.findAll({
        where: {
          project_id: project.id,
        },
      });
      allSubProject = [...allSubProject, getsubProj];
    }
    for (const subProj of allSubProject) {
      if (subProj[0]?.is_approved == false) {
        pendingProj++;
      }
      if (subProj[0]?.is_approved == true) {
        approvedProj++;
      }
      if (subProj[0]?.active == false) {
        rejectedProj++;
      }
    }
    const supervisoDetails = await StudentSupervisor.findOne({
      where: {
        student_user_id: req.user.id,
      },
      raw: true,
    });
    const topicApproved = await ProjectTopic.count({
      where: {
        active: true,
        student_user_id: req.user.id,
        is_approved: true,
      },
    });
    const topics = await ProjectTopic.findAll({
      where: {
        active: true,
        student_user_id: req.user.id,
      },
    });
    let bindingPogress = 0;
    if (bindingPayment?.status == "PAID") {
      bindingPogress = 30;
    } else if (bindingPayment?.status == "SUBMITTED") {
      bindingPogress = 60;
    } else if (bindingPayment?.status == "READY") {
      bindingPogress = 100;
    }
    const sessions = await SchoolSessions.findOne({
      where: { id: req.user.session_id },
    });
    return res.render("student/student_project_binding.ejs", {
      user: req.user,
      error: false,
      pendingProj,
      approvedProj,
      rejectedProj,
      allDoc: JSON.parse(JSON.stringify(allSubProject)).length,
      topics: topics,
      supervisoDetails: supervisoDetails,
      topicApproved,
      subscriptions: req.subscriptions,
      bindingPayment,
      paidForBinding: bindingPayment?.txn_status == "success" ? true : false,
      bindingPogress,
      sessions,
    });

    // just solve xonflict
  } catch (error) {
    console.log(error);
    return res.render("student/student_project_binding.ejs", {
      user: req.user,
      error: error.message,
      pendingProj: 0,
      profile: {},
      topicApproved: 0,
      approvedProj: 0,
      rejectedProj: 0,
      allDoc: 0,
      topics: [],
      supervisoDetails: {},
      subscriptions: req.subscriptions,
      bindingPayment: 0,
      paidForBinding: 0 ? true : false,
      bindingPogress: 0,
    });
  }
};

exports.paymentPlan = async (req, res) => {
  if (req.user.first_login == false)
    return res.redirect(
      "/user/get-started?corass-pro-d=" +
        req.user.id +
        "&id=" +
        req.user.username
    );

  var userSubcription = await Subcriptions.findAll({
    attributes: ["pakage_id"],
    where: {
      active: 1,
      user_id: req.user.id,
    },
  });

  var finalSubcription;
  var PaymentPlan;
  var finalPackages;

  if (userSubcription.length > 0) {
    var arraySub = [];
    for (var userSubcriptions of userSubcription) {
      arraySub.push(userSubcriptions.pakage_id);
    }

    finalSubcription = await Packages.findAll({
      where: {
        active: 1,
        id: arraySub,
      },
    });

    PaymentPlan = await Packages.findAll({
      where: {
        active: 1,
        [Op.not]: [
          {
            id: arraySub,
          },
        ],
      },
    });

    var arrayPlans = [];
    for (var PaymentPlans of PaymentPlan) {
      arrayPlans.push(PaymentPlans.id);
    }

    finalPackages = await Packages.findAll({
      where: {
        active: 1,
        id: arrayPlans,
      },
    });
  } else {
    finalPackages = await Packages.findAll({
      where: {
        active: 1,
      },
    });
    finalSubcription = undefined;
  }

  const sessions = await SchoolSessions.findOne({
    where: { status: true },
  });
  return res.render("student/payments_plan.ejs", {
    user: req.user,
    subscriptions: req.subscriptions,
    profile: req.profile,
    PaymentPlan: finalPackages,
    finalSubcription,
    sessions,
  });
};

exports.payment = async (req, res) => {
  const paystackKey = await PaystackDetails.findAll();
  const paystack = require("paystack")(paystackKey[0].LIVE_SECRET_KEY);
  // const paystack = require("paystack")(paystackKey[0].TEST_SECRET_KEY);
  const paystackReference = req.query.reference;

  if (req.user.first_login == false)
    return res.redirect(
      "/user/get-started?corass-pro-d=" +
        req.user.id +
        "&id=" +
        req.user.username
    );

  var paystackCallbackStatus;
  if (paystackReference != undefined) {
    await paystack.transaction.verify(paystackReference).then((transaction) => {
      paystackCallbackStatus = transaction.data.status;
    });
  }

  if (paystackReference === "") {
    paystackCallbackStatus = undefined;
  }
  const binding_payments = await Bindingpayment.findAll({
    order: [["createdAt", "DESC"]],
    where: {
      user_id: req.user.id,
    },
  });
  var getPayemtHistory = await paymentHistory.findAll({
    order: [["createdAt", "DESC"]],
    where: {
      username: req.user.username,
    },
  });

  var eachPakages = [];

  for (const getPayemtHistories of JSON.parse(
    JSON.stringify(getPayemtHistory)
  )) {
    const GetPackages = await Packages.findOne({
      where: {
        id: getPayemtHistories.package_id,
      },
    });
    eachPakages.push({
      ...getPayemtHistories,
      package_name: GetPackages?.name,
    });
  }
  const sessions = await SchoolSessions.findOne({
    where: { status: true },
  });
  return res.render("student/payments.ejs", {
    user: req.user,
    subscriptions: req.subscriptions,
    trxStatus: paystackCallbackStatus,
    error: {
      statusCode: "500",
      success: false,
      message: "Error",
      error: undefined,
    },
    getPayemtHistory: eachPakages,
    success: {
      statusCode: "200",
      success: false,
      message: paystackCallbackStatus,
    },
    binding_payments,
    sessions,
  });
};

exports.verifyPayment = async (req, res) => {
  try {
    const paystackKey = await PaystackDetails.findAll();
    const paystack = require("paystack")(paystackKey[0].LIVE_SECRET_KEY);
    // const paystack = require("paystack")(paystackKey[0].TEST_SECRET_KEY);
    const paystackReference = req.body.reference;

    if (!paystackReference) {
      return res.status(200).send({
        statusCode: "401",
        success: false,
        message: "Error",
        error: "Payment reference is required",
      });
    }

    var paystackCallbackRes;
    const verifyPay = await paystack.transaction
      .verify(paystackReference)
      .then((transaction) => {
        paystackCallbackRes = transaction.data;
      });

    if (paystackCallbackRes?.status != undefined) {
      var findSUb = await Subcriptions.findOne({
        where: {
          payment_id: paystackCallbackRes.reference,
        },
      });
      if (paystackCallbackRes.status === "success" && findSUb === null) {
        const findPaymentHistory = await paymentHistory.findOne({
          where: {
            txn_ref: paystackCallbackRes.reference,
            username: paystackCallbackRes.metadata.matricNumber,
          },
        });

        const updateUser = {
          payment_status: "PAID",
        };
        const updatePaid = await User.update(updateUser, {
          where: {
            username: paystackCallbackRes.metadata.matricNumber,
          },
        });

        const createSub = await Subcriptions.create({
          user_id: req.user.id,
          payment_id: paystackCallbackRes.reference,
          pakage_id: findPaymentHistory.package_id,
        });

        const updatePayment = {
          txn_desc: paystackCallbackRes.gateway_response,
          txn_status: paystackCallbackRes.status,
          txn_channel: paystackCallbackRes.channel,
        };

        const updateHistory = await paymentHistory.update(updatePayment, {
          where: {
            txn_ref: paystackCallbackRes.reference,
            username: paystackCallbackRes.metadata.matricNumber,
          },
        });

        if (updateHistory && createSub && updatePaid) {
          return res.status(200).send({
            statusCode: "200",
            success: true,
            message: paystackCallbackRes.gateway_response,
          });
        }
      } else {
        const updatePayment = {
          txn_desc: paystackCallbackRes.gateway_response,
          txn_status: paystackCallbackRes.status,
          txn_channel: paystackCallbackRes.channel,
        };

        const updateHistory = await paymentHistory.update(updatePayment, {
          where: {
            txn_ref: paystackCallbackRes.reference,
            username: paystackCallbackRes.metadata.matricNumber,
          },
        });

        if (updateHistory) {
          return res.status(200).send({
            statusCode: "200",
            success: true,
            message: paystackCallbackRes.gateway_response,
          });
        }
      }
    }
  } catch (e) {
    console.log(e);
    res.status(500).send({
      statusCode: "500",
      success: false,
      message: "Error",
      error: e.message,
    });
  }
};

exports.projectSubmission = async (req, res) => {
  if (!req.user.first_login) {
    return res.redirect(
      `/user/get-started?corass-pro-d=${req.user.id}&id=${req.user.username}`
    );
  }

  try {
    const [topics, supervisor] = await Promise.all([
      ProjectTopic.findOne({
        where: {
          student_user_id: req.user.id,
          active: true,
          is_approved: true,
        },
        include: [
          {
            model: ProjectSubmission,
            include: [
              { model: DocumentCategory, attributes: ["name"] },
              {
                model: ProjectTopic,
                include: [
                  {
                    model: User,
                    as: "lecturer",
                    attributes: ["username"],
                    include: [
                      {
                        model: Profile,
                        attributes: ["firstname", "lastname", "middlename"],
                      },
                    ],
                  },
                ],
              },
            ],
          },
        ],
      }),
      StudentSupervisor.findOne({
        where: { student_user_id: req.user.id, active: true },
      }),
    ]);

    const sessions = await SchoolSessions.findOne({
      where: { id: req.user.session_id },
    });
    return res.render("student/project_submission.ejs", {
      user: req.user,
      subscriptions: req.subscriptions,
      topics,
      supervisor: JSON.parse(JSON.stringify(supervisor)),
      sessions,
    });
  } catch (error) {
    console.error("Error in projectSubmission:", error);
    // Handle the error appropriately (e.g., send an error response or render an error page)
    return res.status(500).send("An error occurred.");
  }
};

exports.project = async (req, res) => {
  if (req.user.first_login == false)
    return res.redirect(
      "/user/get-started?corass-pro-d=" +
        req.user.id +
        "&id=" +
        req.user.username
    );
  const sessions = await SchoolSessions.findOne({
    where: { status: true },
  });
  return res.render("student/student_project.ejs", {
    user: req.user,
    subscriptions: req.subscriptions,
    sessions,
  });
};

exports.siwes = async (req, res) => {
  if (req.user.first_login == false)
    return res.redirect(
      "/user/get-started?corass-pro-d=" +
        req.user.id +
        "&id=" +
        req.user.username
    );
  try {
    let supervisor = await StudentSupervisor.findOne({
      where: { student_user_id: req.user.id, active: true, project_type_id: 4 },
      include: [
        {
          model: User,
          as: "lecturer",
          include: [{ model: Profile }],
        },
      ],
    });
    const projects = await Siwes.findAll({
      where: {
        active: 1,
        student_user_id: req.user.id,
      },
    });
    const sessions = await SchoolSessions.findOne({
      where: { id: req.user.session_id },
    });
    return res.render("student/student_siwes.ejs", {
      user: req.user,
      subscriptions: req.subscriptions,
      projects,
      supervisor,
      sessions,
    });
  } catch (e) {}
};

exports.topicSubmission = async (req, res) => {
  if (req.user.first_login == false)
    return res.redirect(
      "/user/get-started?corass-pro-d=" +
        req.user.id +
        "&id=" +
        req.user.username
    );
  try {
    const allTopic = [];
    const topics = await ProjectTopic.findAll({
      where: {
        student_user_id: req.user.id,
      },
      include: [
        {
          model: ProjectType,
        },
      ],
    });
    const supervisoDetails = await StudentSupervisor.findOne({
      where: {
        student_user_id: req.user.id,
      },
    });

    const sessions = await SchoolSessions.findOne({
      where: { id: req.user.session_id },
    });
    return res.render("student/topic_submission.ejs", {
      user: req.user,
      subscriptions: req.subscriptions,
      ProjectTopicData: topics,
      supervisoDetails,
      sessions,
    });
  } catch (e) {
    console.log(e);
    return res.render("student/topic_submission.ejs", {
      user: req.user,
      subscriptions: req.subscriptions,
      ProjectTopicData: [],
      error: e.message,
      supervisoDetails: {},
      sessions,
    });
  }
};

exports.acknownledge = async (req, res) => {
  if (req.user.first_login == false)
    return res.redirect(
      "/user/get-started?corass-pro-d=" +
        req.user.id +
        "&id=" +
        req.user.username
    );
  const project = await ProjectTopic.findOne({
    where: { student_user_id: req.user.id, active: true, is_approved: true },
    include: [
      {
        model: ProjectSubmission,
        require: true,
        where: { document_category_id: 7 },
        include: [
          {
            model: DocumentCategory,
            attributes: ["name"],
          },
          {
            model: ProjectTopic,
            include: [
              {
                model: User,
                as: "lecturer",
                attributes: ["username"],
                include: [
                  {
                    model: Profile,
                    attributes: ["firstname", "lastname", "middlename"],
                  },
                ],
              },
            ],
          },
        ],
      },
    ],
  });
  const sessions = await SchoolSessions.findOne({
    where: { id: req.user.session_id },
  });
  if (!project) return res.redirect("/student-dashboard");
  return res.render("student/note.ejs", {
    user: req.user,
    subscriptions: req.subscriptions,
    project,
    sessions,
  });
};

exports.receipt = async (req, res) => {
  if (req.user.first_login == false)
    return res.redirect(
      "/user/get-started?corass-pro-d=" +
        req.user.id +
        "&id=" +
        req.user.username
    );

  const txnReference = req.query.reference;
  const username = req.query.MatricNo;

  const user = await User.findOne({
    where: {
      username: username,
    },
  });

  const MypaymentHistory = await paymentHistory.findOne({
    where: {
      id: txnReference,
    },
  });

  const GetPackages = await Packages.findOne({
    where: {
      id: MypaymentHistory.package_id,
    },
  });

  const GetSession = await SchoolSessions.findAll({});

  const url = req.headers.host + req.url;

  qr.toDataURL(url, (err, src) => {
    if (err) res.send("Error occured");

    return res.render("receipt.ejs", {
      user,
      MypaymentHistory,
      subscriptions: req.subscriptions,
      profile: req.profile,
      Sessions: GetSession[0].name,
      src,
      GetPackages,
    });
  });
};

exports.projectUpload = async (req, res) => {
  try {
    const { project_id, document_category_id, description } = req.body;

    if (!document_category_id) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: "Error",
        error: "Document Category is required",
      });
    }

    if (req.file == undefined) {
      return res.status(400).send("Please upload a valid file!");
    }
    let path = req.file.filename;
    let mainId = "";
    const auth = new GoogleAuth({
      keyFile: __dirname + "/corass-project-20725bec603b.json",
      //   keyFile: __dirname + "/corass-project-d504ee650748.json",
      scopes: ["https://www.googleapis.com/auth/drive"],
    });
    const client = await auth.getClient();

    const drive = google.drive({ version: "v3", auth: client });

    const fileMetadata = {
      name: path,
      mimeType: "application/vnd.google-apps.document",
    };

    const media = {
      mimeType: mime.getType("./project/" + path),
      body: fs.createReadStream("./project/" + path),
    };
    drive.files.create(
      {
        resource: fileMetadata,
        media: media,
        fields: "id",
      },
      async (err, file) => {
        if (err) {
          // Handle the error
          console.error(err);
          return;
        }
        mainId = file.data.id;
        const permission = {
          type: "anyone",
          role: "writer",
          allowFileDiscovery: true,
        };
        drive.permissions.create(
          {
            fileId: mainId,
            sendNotificationEmail: false,
            resource: permission,
          },
          async (err, res) => {
            if (err) {
              // Handle the error
              console.error(err);
              return;
            }
            await ProjectSubmission.create({
              project_id,
              document_category_id,
              description,
              document_path: path,
              is_approved: true,
              slug: mainId,
            });
          }
        );
      }
    );
    return res.status(200).send({
      success: true,
      message: "Project successfully created",
    });
  } catch (e) {
    console.log(e);
    res.status(500).send({
      statusCode: "500",
      success: false,
      message: "Error",
      error: e.message,
    });
  }
};
exports.finalProjectUpload = async (req, res) => {
  try {
    const { project_id, document_category_id, description } = req.body;

    if (!document_category_id) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: "Error",
        error: "Document Category is required",
      });
    }

    if (req.file == undefined) {
      return res.status(400).send("Please upload a valid file!");
    }
    let path = req.file.filename;
    let mainId = "";
    const auth = new GoogleAuth({
      keyFile: __dirname + "/corass-project-20725bec603b.json",
      scopes: ["https://www.googleapis.com/auth/drive"],
    });
    const client = await auth.getClient();

    const drive = google.drive({ version: "v3", auth: client });

    const fileMetadata = {
      name: path,
      mimeType: "application/vnd.google-apps.document",
    };

    const media = {
      mimeType: mime.getType("./project/final/" + path),
      body: fs.createReadStream("./project/final/" + path),
    };
    await ProjectSubmission.create({
      project_id,
      document_category_id,
      description,
      document_path: path,
      is_approved: true,
      slug: path,
    });
    drive.files.create(
      {
        resource: fileMetadata,
        media: media,
        fields: "id",
      },
      async (err, file) => {
        if (err) {
          // Handle the error
          console.error(err);
          return;
        }
        mainId = file.data.id;
        const permission = {
          type: "anyone",
          role: "writer",
          allowFileDiscovery: true,
        };
        drive.permissions.create(
          {
            fileId: mainId,
            sendNotificationEmail: false,
            resource: permission,
          },
          async (err, res) => {
            if (err) {
              // Handle the error
              console.error(err);
              return;
            }
            await ProjectSubmission.create({
              project_id,
              document_category_id,
              description,
              document_path: path,
              is_approved: true,
              slug: mainId,
            });
          }
        );
      }
    );

    return res.status(200).send({
      success: true,
      message: "Project successfully created",
    });
  } catch (e) {
    console.log(e);
    res.status(500).send({
      statusCode: "500",
      success: false,
      message: "Error",
      error: e.message,
    });
  }
};
exports.deleteProject = async (req, res) => {
  const { id } = req.params;
  await ProjectSubmission.destroy({
    where: {
      id,
    },
  });
  return res.redirect("/project-submission");
};
exports.siwesUpload = async (req, res) => {
  try {
    const { title, description } = req.body;

    if (!title) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: "Error",
        error: "Title is required",
      });
    }

    if (req.file == undefined) {
      return res.status(400).send("Please upload a valid file!");
    }
    let path = req.file.filename;
    let mainId = "";
    const auth = new GoogleAuth({
      keyFile: __dirname + "/corass-project-20725bec603b.json",
      scopes: ["https://www.googleapis.com/auth/drive"],
    });
    const client = await auth.getClient();

    const drive = google.drive({ version: "v3", auth: client });

    const fileMetadata = {
      name: path,
      mimeType: "application/vnd.google-apps.document",
    };

    const media = {
      mimeType: mime.getType("./project/" + path),
      body: fs.createReadStream("./project/" + path),
    };
    drive.files.create(
      {
        resource: fileMetadata,
        media: media,
        fields: "id",
      },
      async (err, file) => {
        if (err) {
          // Handle the error
          console.error(err);
          return;
        }
        mainId = file.data.id;
        console.log(`File ID: ${file.data.id}`);
        const permission = {
          type: "anyone",
          role: "writer",
          allowFileDiscovery: true,
        };
        drive.permissions.create(
          {
            fileId: mainId,
            sendNotificationEmail: false,
            resource: permission,
          },
          async (err, res) => {
            if (err) {
              // Handle the error
              console.error(err);
              return;
            }
            const project = await Siwes.create({
              title,
              student_user_id: req.user.id,
              description,
              document_path: path,
              is_approved: false,
              slug: mainId,
              active: true,
            });
          }
        );
      }
    );
    return res.status(200).send({
      success: true,
    });
  } catch (e) {
    console.log(e);
    res.status(500).send({
      statusCode: "500",
      success: false,
      message: "Error",
      error: e.message,
    });
  }
};
exports.deleteSiwes = async (req, res) => {
  const { id } = req.params;
  await Siwes.destroy({
    where: {
      id,
    },
  });
  return res.redirect("/siwes");
};
exports.renderPdf = async (req, res) => {
  try {
    let mainId = "";
    const auth = new GoogleAuth({
      keyFile: __dirname + "/corass-project-20725bec603b.json",
      scopes: ["https://www.googleapis.com/auth/drive"],
    });
    const client = await auth.getClient();

    const drive = google.drive({ version: "v3", auth: client });

    const fileMetadata = {
      name: "My Google Doc",
      mimeType: "application/vnd.google-apps.document",
    };

    const media = {
      mimeType: mime.getType(
        "./project/1672791927524-corass-project-360_email_for_participant_and_eval.docx"
      ),
      body: fs.createReadStream(
        "./project/1672791927524-corass-project-360_email_for_participant_and_eval.docx"
      ),
    };
    drive.files.create(
      {
        resource: fileMetadata,
        media: media,
        fields: "id",
      },
      async (err, file) => {
        if (err) {
          // Handle the error
          console.error(err);
          return;
        }
        mainId = file.data.id;
        console.log(`File ID: ${file.data.id}`);
        const permission = {
          type: "anyone",
          role: "writer",
          allowFileDiscovery: true,
        };
        drive.permissions.create(
          {
            fileId: mainId,
            sendNotificationEmail: false,
            resource: permission,
          },
          (err, res) => {
            if (err) {
              // Handle the error
              console.error(err);
              return;
            }
            done();
          }
        );
      }
    );

    function done() {
      res.render("template.ejs", { id: mainId });
    }
  } catch (error) {
    console.log(error);
  }
};
exports.viewDocument = async (req, res) => {
  const { docId } = req.params;
  const doc = await ProjectSubmission.findOne({
    where: {
      id: docId,
    },
    raw: true,
  });
  res.render("studentTemplate.ejs", { doc });
};

exports.bindingReceipt = async (req, res) => {
  const userId = req.params.userId;

  const user = await User.findOne({
    where: {
      id: userId,
    },
    attributes: [
      "firstname",
      "lastname",
      "middlename",
      "id",
      "photo_path",
      "username",
    ],
    include: [
      {
        model: Study_modes,
        attributes: ["name"],
      },
      {
        model: Department,
        attributes: ["id", "name"],
        include: [
          {
            model: Institute,
            attributes: ["name"],
          },
        ],
      },
    ],
  });

  const MypaymentHistory = await Bindingpayment.findOne({
    where: {
      user_id: userId,
      txn_status: "success",
    },
  });

  const url = req.headers.host + req.url;
  qr.toDataURL(url, (err, src) => {
    if (err) res.send("Error occured");

    return res.render("student/binding-receipt.ejs", {
      user,
      MypaymentHistory,
      subscriptions: req.subscriptions,
      src,
    });
  });
};

exports.allReceipt = async (req, res) => {
  try {
    const userId = req.query.username;
    let eachPakages = [];
    const user = await User.findOne({
      where: {
        username: userId,
      },
      raw: true,
    });
    if (!user) return res.redirect("/student-dashboard");
    const profile = await Profile.findOne({
      where: { user_id: user.id },
      include: [
        {
          model: User,
          attributes: ["username"],
        },
        {
          model: Study_modes,
          attributes: ["name"],
        },
        {
          model: Department,
          attributes: ["id", "name"],
          include: [
            {
              model: Institute,
              attributes: ["name"],
            },
          ],
        },
      ],
    });
    const MypaymentHistory = await Bindingpayment.findOne({
      where: {
        user_id: user.id,
        txn_status: "success",
      },
    });
    const GetSession = await SchoolSessions.findOne({
      where: { status: true },
    });
    const allPayment = await paymentHistory.findAll({
      where: {
        username: user.username,
        txn_status: "success",
      },
      raw: true,
    });
    for (const getPayemtHistories of allPayment) {
      const GetPackages = await Packages.findOne({
        where: {
          id: getPayemtHistories.package_id,
        },
      });
      eachPakages.push({
        ...getPayemtHistories,
        package_name: GetPackages?.name,
      });
    }
    const url = req.headers.host + req.url;
    qr.toDataURL(url, (err, src) => {
      if (err) res.send("Error occured");

      return res.render("combinedReceipt.ejs", {
        user,
        getPayemtHistory: eachPakages,
        subscriptions: req.subscriptions,
        profile,
        src,
        Sessions: GetSession.name,
        session: GetSession,
        bindingPayment: MypaymentHistory,
      });
    });
  } catch (error) {
    return res.redirect("/student-dashboard");
  }
};

exports.acknownledgeSlip = async (req, res) => {
  const userId = req.query.username;

  const project = await ProjectTopic.findOne({
    where: { student_user_id: userId, active: true, is_approved: true },
    include: [
      {
        model: ProjectSubmission,
        require: true,
        where: { document_category_id: 7 },
        include: [
          {
            model: DocumentCategory,
            attributes: ["name"],
          },
          {
            model: User,
            as: "student",
            attributes: [
              "username",
              "email",
              "firstname",
              "lastname",
              "middlename",
              "photo_path",
            ],
            include: [
              {
                model: Department,
                attributes: ["id", "name"],
                include: [
                  {
                    model: Institute,
                    attributes: ["name"],
                  },
                ],
              },
            ],
          },
        ],
      },
    ],
  });
  const supervisor = await StudentSupervisor.findOne({
    where: {
      student_user_id: userId,
    },
    raw: true,
  });
  const GetSession = await SchoolSessions.findAll({});
  const url = req.headers.host + req.url;
  qr.toDataURL(url, (err, src) => {
    if (err) res.send("Error occured");

    return res.render("ack2.ejs", {
      project,
      subscriptions: req.subscriptions,
      src,
      Sessions: GetSession[0]?.name,
      supervisor,
    });
  });
};
exports.acknownledgeSlip2 = async (req, res) => {
  let userId;
  if (req.url.includes("??")) {
    const regex = /username=([a-fA-F0-9-]+)/;
    const match = req.url.match(regex);
    userId = match[1];
  } else {
    userId = req.query.username;
  }
  console.log(userId);
  let project = await ProjectTopic.findOne({
    where: { student_user_id: userId, active: true, is_approved: true },
    include: [
      {
        model: User,
        as: "student",
        attributes: [
          "username",
          "email",
          "firstname",
          "lastname",
          "middlename",
          "photo_path",
        ],
        include: [
          {
            model: Department,
            attributes: ["id", "name"],
            include: [
              {
                model: Institute,
                attributes: ["name"],
              },
            ],
          },
        ],
      },
    ],
  });
  project = JSON.parse(JSON.stringify(project));
  const supervisor = await StudentSupervisor.findOne({
    where: {
      student_user_id: userId,
    },
    raw: true,
  });
  const GetSession = await SchoolSessions.findOne({ where: { status: true } });
  const url = req.headers.host + req.url;
  qr.toDataURL(url, (err, src) => {
    if (err) res.send("Error occured");

    return res.render("ack2.ejs", {
      project,
      subscriptions: req.subscriptions,
      src,
      Sessions: GetSession?.name,
      session: GetSession,
      supervisor,
    });
  });
};
