const User = require("../../models").users;

const verify = async (req, res, next) => {
  if (req.user.first_login == false) return res.redirect("/user/get-started");
  try {
    const payment_verify = await User.findOne({
      where: {
        username: req.user.username,
        payment_status: "PAID",
      },
      attributes:["id"]
    });

    if (!payment_verify) {
      return res.render("student/student_dashboard.ejs", {
        user: req.user,
        subscriptions: req.subscriptions,
        error: {
          statusCode: "409",
          success: false,
          message: "Error",
          error: `You can't access some CORASS features, if you haven't pay access fee`,
        },
        success: false,
      });
    }

    next();
  } catch (e) {
    console.log(e);
    return res.render("login/student.ejs", {
      error: {
        statusCode: "401",
        success: false,
        message: "Error",
        error: e.message,
      },
    });
  }
};

module.exports = verify;
