const express = require("express");
const router = express.Router();
const paymentReportController = require("../../controllers/admin/paymentController");
const upload = require("../../helpers/upload");

router.get("/paymentreport", paymentReportController.paymentReport);
router.get("/payment-audit", paymentReportController.paymentAudit);
router.get("/binding-payment", paymentReportController.bindingPaymentReport);
router.post("/binding-update", paymentReportController.upateBindingStatus);
router.get(
  "/binding-record/:session_id",
  paymentReportController.bindingRecord
);
router.get("/paymentrequery", paymentReportController.paymentRequery);
router.get("/paymentswap", paymentReportController.paymentSwap);
router.post("/swappayment", paymentReportController.SwapPayment);
router.post("/transaction/verify", paymentReportController.verifyPayment);
router.post(
  "/binding-transaction/verify",
  paymentReportController.verifyPaymentBinding
);
router.post("/payment/swap", paymentReportController.SwapPayment);
router.post("/payment/swapSub", paymentReportController.SwapPaymentSubcription);
router.post("/create-group", paymentReportController.createGroup);
router.post(
  "/create-bulk-group",
  upload.single("file"),
  paymentReportController.groupBulkUpload
);
router.get("/binding-group", paymentReportController.bindingRecordGroup);

module.exports = router;
