const express = require("express");
const router = express.Router();
const studentController = require("../../controllers/admin/studentController");
const upload = require("../../helpers/upload");

router.get(
  "/department-supervisor/:department_id",
  studentController.getSupervisorByDepartment
);
router.get("/student-account", studentController.profile);
router.get("/student-account-security", studentController.profile2);
router.get("/students/:session_id", studentController.studentReport);
router.get("/view-cover/:user_id", studentController.studentCover);
router.post("/single-upload", studentController.singleStudentUplod);
router.post("/upload", upload.single("file"), studentController.studentUpload);
router.get("/view-group-cover/:user_id", studentController.groupCover);
module.exports = router;
