const express = require("express");
const router = express.Router();
var homeController = require("../controllers/home.controller")
var studenteMiddleware = require("../middleware/student.middleware")
var studentPayment = require("../middleware/payment.middleware")
var authMiddleware = require("../middleware/studentAuth.middleware")
const studentController = require('../controllers/admin/studentController')

var staffMiddleware = require("../middleware/staff.middleware")
var authMiddlewareStaff = require("../middleware/staffAuth.middleware.js")

router.get('/', homeController.home);
router.get('/student-login', homeController.studentLogin);
router.get('/staff-login', homeController.staffLogin);
router.get('/profile-account', authMiddleware,  studenteMiddleware, homeController.profile);
router.get('/profile-security',  authMiddleware, studenteMiddleware,homeController.profile2);
router.get('/profile-payment', authMiddleware, studenteMiddleware, homeController.profile3);
router.get('/project/view-cover/:user_id', studentController.studentCover);

router.get('/profile-staff-account', authMiddlewareStaff,  homeController.profile);
router.get('/profile-staff-security',  authMiddlewareStaff, homeController.profile2);
router.get('/profile-staff-payment', authMiddlewareStaff, staffMiddleware, homeController.profile3);
module.exports = router;
 