const studentRoute = require("./student.route")
const loginRoute = require("./auth.route")
const dashboardRoute = require("./dashboard.route")
const forgotPasswordRoute = require("./forgotPassword.route")
const changePasswordRoute = require("./changePassword.route")
const profileRoute = require("./profile.route")
const researchLibraryRoute = require("./researchLibraryRoute")
const newTopicRoute = require("./newProjectTopic.route")
const homeRoute = require("./home.route")
const staffDashboardRoute = require("./staff-dashboard.route")
const studentDashboardRoute = require("./student-dashboard.route")
const paystackInitRoute = require('../routes/paystack.route')

var authMiddleware = require("../middleware/staffAuth.middleware.js")
// ? Admin Routes
const schoolSettingsRoute = require("./admin/schoolsettingRoute")
const adminProjectRouter = require("./admin/projectRoute")
const supervisorRoute = require("./admin/supervisorRoute")
const adminPaymentRouter = require("./admin/paymentRoute")
const instituteRoute = require("./admin/instituteRoute")
const studentRouteAdmin = require("./admin/studentRoute")
const adminusersRoute = require("./admin/adminusersRoute")
const roleRoute = require("./admin/roleRoute")
const paymentPlanRoute = require("./admin/paymentPlanRoute")
const departmentRoute = require("./admin/departmentRoute")

// ? Admin Routes
const exsession = require('express-session')

module.exports = (app) => {
  app.use(exsession({
    secret: "corassHub3904",
    resave: false,
    saveUninitialized: true
  }));
  
  app.use("/admin",authMiddleware, paymentPlanRoute);
  app.use("/admin",authMiddleware, departmentRoute);
  app.use("/admin",authMiddleware, roleRoute);
  app.use("/admin",authMiddleware, adminusersRoute);
  app.use("/admin",authMiddleware, studentRouteAdmin);
  app.use("/admin",authMiddleware, instituteRoute);
  app.use("/admin", authMiddleware,supervisorRoute);
  app.use("/admin", authMiddleware,schoolSettingsRoute);
  app.use("/admin",authMiddleware, adminProjectRouter);
  app.use("/admin",authMiddleware, adminPaymentRouter);
  app.use("/", homeRoute);
  app.use("/", staffDashboardRoute);
  app.use("/", studentDashboardRoute);
  app.use("/student", studentRoute);
  app.use("/research", researchLibraryRoute);
  app.use("/user", loginRoute);
  app.use("/account", dashboardRoute);
  app.use("/user", forgotPasswordRoute);
  app.use("/user", changePasswordRoute)
  app.use("/user", profileRoute)
  app.use("/user", newTopicRoute)
  app.use("/user", paystackInitRoute)
};
