const express = require("express");
const router = express.Router();
const paystackInitController = require("../controllers/paystack-transaction-init.controller")
const paystackWebhookController = require("../controllers/paystackWebhook.controller")
const paystacVrifyController = require("../controllers/student-dashboard.controller")
var authMiddleware = require("../middleware/studentAuth.middleware")



router.post('/transaction/initialize', authMiddleware, paystackInitController.initializeTransaction);
router.post('/transaction/initialize/binding', authMiddleware, paystackInitController.initializeTransactionBinding);
router.post('/transaction/verify', authMiddleware, paystacVrifyController.verifyPayment);
router.post('/transaction-binding/verify', authMiddleware, paystackInitController.verifyPaymentBinding);
router.post('/webhook/paymentplan', paystackWebhookController.webhook);
router.post('/webhook/kwcoedilorin', paystackInitController.initializeTransactionBindingMannually);
module.exports = router;
 