const express = require("express");
const router = express.Router();
var staffDashboardController = require("../controllers/staff-dashboard.controller")
var staffMiddleware = require("../middleware/staff.middleware")
var authMiddleware = require("../middleware/staffAuth.middleware.js")



router.get('/staff-dashboard', authMiddleware, staffMiddleware, staffDashboardController.staffDashboard);
router.get('/student-management', authMiddleware, staffMiddleware, staffDashboardController.studentManagemt);
router.get('/research', authMiddleware, staffDashboardController.researchLibrary);
router.get('/library-access', authMiddleware, staffDashboardController.accessManagement);
router.get('/assigned-student', authMiddleware, staffMiddleware, staffDashboardController.myAssignStuent);
router.get('/student-project', authMiddleware, staffMiddleware, staffDashboardController.studentProject);
router.get('/all-project', authMiddleware, staffMiddleware, staffDashboardController.allProjects);
router.get('/view-project/:docId', authMiddleware, staffMiddleware, staffDashboardController.viewStudentProject);
router.get('/view-topic/:id', authMiddleware, staffMiddleware, staffDashboardController.getTopicById);
router.get('/topic', authMiddleware, staffMiddleware,staffDashboardController.topic);
router.post('/approve-topic', authMiddleware, staffMiddleware,staffDashboardController.approveTopic);
router.post('/document-topic', staffDashboardController.approveDocument);
router.get('/getProjectStudentForLecturer/:term/:prop', authMiddleware, staffMiddleware, staffDashboardController.getProjectStudentForLecturer);
router.get('/searchStudentProject',authMiddleware, staffMiddleware, staffDashboardController.searchStudentProject);
router.get('/studentManagemtFilter/:term/:prop',authMiddleware, staffMiddleware, staffDashboardController.studentManagemtFilter);
router.get('/studentManagemtSearchFilter/:term', authMiddleware, staffMiddleware, staffDashboardController.studentManagemtSearchFilter);
router.get('/student-account', staffDashboardController.profile);
router.get('/student-account-security', staffDashboardController.profile2);

module.exports = router;
 