const express = require("express");
const router = express.Router();
var studentDashboardController = require("../controllers/student-dashboard.controller")
var studenteMiddleware = require("../middleware/student.middleware")
var studentPayment = require("../middleware/payment.middleware")
var authMiddleware = require("../middleware/studentAuth.middleware")
const upload = require("../helpers/projectUpload");
const uploadFinal = require("../helpers/finalProjectUpload");


router.get('/student-dashboard', authMiddleware, studenteMiddleware, studentDashboardController.studentDashboard);
router.get('/project-binding', authMiddleware, studenteMiddleware, studentDashboardController.studentProjectBindingDashboard);
router.get('/payment-plan', authMiddleware, studenteMiddleware, studentDashboardController.paymentPlan);
router.get('/payment-history', authMiddleware, studenteMiddleware, studentDashboardController.payment);
router.get('/project-submission',  authMiddleware,  studenteMiddleware, studentDashboardController.projectSubmission);
router.get('/project', authMiddleware,  studenteMiddleware, studentDashboardController.project);
router.get('/siwes',  authMiddleware,  studenteMiddleware, studentDashboardController.siwes);
router.get('/topic-submission', authMiddleware,  studenteMiddleware,  studentDashboardController.topicSubmission);
router.get('/acknownledge',authMiddleware, studenteMiddleware, studentDashboardController.acknownledge);
router.get('/receipt',authMiddleware, studenteMiddleware, studentDashboardController.receipt);
router.post('/project-upload', upload.single("file"),   studentDashboardController.projectUpload);
router.post('/project-upload-final', uploadFinal.single("file"),   studentDashboardController.finalProjectUpload);
router.post('/siwes-upload', upload.single("file"),authMiddleware , studenteMiddleware,    studentDashboardController.siwesUpload);
router.get('/project-delete/:id', authMiddleware , studenteMiddleware,   studentDashboardController.deleteProject);
router.get('/siwes-delete/:id',  authMiddleware , studenteMiddleware,  studentDashboardController.deleteSiwes);
router.get('/render-pdf',   studentDashboardController.renderPdf);
router.get('/view-document/:docId', authMiddleware , studenteMiddleware,   studentDashboardController.viewDocument);
router.get('/binding-receipt/:userId', studentDashboardController.bindingReceipt);
router.get('/all-receipt', studentDashboardController.allReceipt);
router.get('/acknownledge-slip', studentDashboardController.acknownledgeSlip2);

module.exports = router;
 